Write-Output "Looking for [$($deployed.name)] in list of installed applications."
$app = Get-WmiObject -Class Win32_Product -Computer . | Where-Object { $_.Name -match $deployed.name }
if(!$app) {
	Write-Output "Cannot uninstall application [$($deployed.name)] because it cannot be found."
	Exit 1
}

Write-Output "Uninstalling [$($deployed.name)]"
$app.uninstall() | Out-Null
