/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.contributor.webserver;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.services.Repository;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.WasContainer;
import com.xebialabs.deployit.plugin.was.contributor.CollectDeployedsOfTypesContributor;
import com.xebialabs.deployit.plugin.was.deployed.ExtensibleDeployedArtifact;
import com.xebialabs.deployit.plugin.was.util.Predicates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReferencedWebserverContributor
extends CollectDeployedsOfTypesContributor<ExtensibleDeployedArtifact> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReferencedWebserverContributor.class);
    static final String WEBSERVERS_PROPERTY = "webServers";
    static final String WEBSERVER_NAMES_PROPERTY = "webServerNames";
    static final String WEBMODULES_PROPERTY = "webModules";
    private static final Predicate<ConfigurationItem> IS_EAR_OR_WAR_MODULE = com.google.common.base.Predicates.or(Predicates.instanceOf(Type.valueOf((String)"was.EarModule")), Predicates.instanceOf(Type.valueOf((String)"was.WarModule")));

    public AbstractReferencedWebserverContributor() {
        super(Type.valueOf(ExtensibleDeployedArtifact.class));
    }

    protected Set<ManagedWebServer> getReferencedWebservers(DeploymentPlanningContext ctx) {
        ImmutableSet.Builder webservers = ImmutableSet.builder();
        for (ExtensibleDeployedArtifact earOrWarModule : this.getEarAndWarModules()) {
            Set referencedWebservers = (Set)earOrWarModule.getProperty(WEBSERVERS_PROPERTY);
            if (referencedWebservers != null) {
                webservers.addAll((Iterable)referencedWebservers);
            }
            Set webServerNames = Sets.newConcurrentHashSet();
            Set webModules = (Set)earOrWarModule.getProperty(WEBMODULES_PROPERTY);
            for (ConfigurationItem webModule : webModules) {
                Set names = (Set)webModule.getProperty(WEBSERVER_NAMES_PROPERTY);
                webServerNames.addAll(names);
            }
            Set names = (Set)earOrWarModule.getProperty(WEBSERVER_NAMES_PROPERTY);
            webServerNames.addAll(names);
            WasContainer container = (WasContainer)earOrWarModule.getContainer();
            webservers.addAll(this.findWebServers(ctx, container, webServerNames));
        }
        return webservers.build();
    }

    private Iterable<? extends ManagedWebServer> findWebServers(DeploymentPlanningContext ctx, WasContainer container, Set<String> webServerNames) {
        ImmutableSet.Builder webServers = ImmutableSet.builder();
        for (String webServerName : webServerNames) {
            ManagedWebServer server = this.findWebServer(ctx, container, webServerName);
            if (null == server) continue;
            webServers.add((Object)server);
        }
        return webServers.build();
    }

    private ManagedWebServer findWebServer(DeploymentPlanningContext ctx, WasContainer container, String webServerName) {
        ManagedWebServer server = null;
        if (webServerName.startsWith("WebSphere:")) {
            server = this.findWebServer(ctx, container, webServerName, this.filterByFullName(webServerName));
        } else if (!webServerName.trim().equals("")) {
            server = this.findWebServer(ctx, container, webServerName, this.filterByName(webServerName));
        }
        return server;
    }

    private ManagedWebServer findWebServer(DeploymentPlanningContext ctx, WasContainer container, String webServerName, Predicate<ManagedWebServer> predicate) {
        ManagedWebServer server = null;
        Repository repository = ctx.getRepository();
        final String cellId = container.getCell().getId();
        List webServers = repository.search(Type.valueOf(ManagedWebServer.class));
        ArrayList webServersUnderSameCell = Lists.newArrayList((Iterable)Iterables.filter((Iterable)webServers, (Predicate)new Predicate<ManagedWebServer>(){

            public boolean apply(ManagedWebServer input) {
                return input.getId().startsWith(cellId + "/");
            }
        }));
        ArrayList foundServers = Lists.newArrayList((Iterable)Iterables.filter((Iterable)webServersUnderSameCell, predicate));
        if (foundServers.size() != 1) {
            if (foundServers.size() > 1) {
                logger.error("Found more than one web server with name: {} under cell {}", (Object)webServerName, (Object)cellId);
                throw new IllegalStateException(String.format("Found more than one web server with name: %s under cell %s", webServerName, cellId));
            }
            logger.error("Didn't find web server with name: {} under cell {}", (Object)webServerName, (Object)cellId);
            throw new IllegalStateException(String.format("Didn't find web server with name: %s under cell %s", webServerName, cellId));
        }
        server = (ManagedWebServer)foundServers.get(0);
        return server;
    }

    private Predicate<ManagedWebServer> filterByName(final String webServerName) {
        return new Predicate<ManagedWebServer>(){

            public boolean apply(ManagedWebServer input) {
                return input.getName().equals(webServerName);
            }
        };
    }

    protected Predicate<ManagedWebServer> filterByFullName(String webServerName) {
        try {
            Pattern p = Pattern.compile("WebSphere:cell=(.*),node=(.*),server=(.*)");
            Matcher matcher = p.matcher(webServerName);
            matcher.matches();
            final String serverCellName = matcher.group(1);
            final String serverNodeName = matcher.group(2);
            final String serverName = matcher.group(3);
            return new Predicate<ManagedWebServer>(){

                public boolean apply(ManagedWebServer input) {
                    return input.getNode().getCell().getCellName().equals(serverCellName) && input.getName().equals(serverName) && input.getNode().getNodeName().equals(serverNodeName);
                }
            };
        }
        catch (Throwable t) {
            String msg = String.format("Unable to create filter for web server name '%s'", webServerName);
            logger.error(msg, t);
            throw new IllegalStateException(msg, t);
        }
    }

    private Collection<ExtensibleDeployedArtifact> getEarAndWarModules() {
        ImmutableList.Builder earAndWarModules = ImmutableList.builder();
        earAndWarModules.addAll(Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsCreated, (Iterable)this.deployedsRemoved), IS_EAR_OR_WAR_MODULE));
        Iterable earAndWarModuleDeltas = Iterables.filter((Iterable)Iterables.concat((Iterable)this.deployedsModified, (Iterable)this.deployedsNoop), (Predicate)new Predicate<CollectDeployedsOfTypesContributor.TypedDelta>(){

            public boolean apply(CollectDeployedsOfTypesContributor.TypedDelta input) {
                return IS_EAR_OR_WAR_MODULE.apply(input.getDeployed());
            }
        });
        for (CollectDeployedsOfTypesContributor.TypedDelta earOrWarModuleDelta : earAndWarModuleDeltas) {
            earAndWarModules.add(earOrWarModuleDelta.getPrevious());
            earAndWarModules.add(earOrWarModuleDelta.getDeployed());
        }
        return earAndWarModules.build();
    }
}

