import re

def inspectHealthPolicyMembership(memberId, healthPolicyName):
    discovered(memberId, 'was.HealthPolicyMembership')
    inspectedProperty(memberId, 'healthPolicyName', healthPolicyName)
    inspectedItem(memberId)

def containerMatches(container, membershipType, memberString):
    name = container.name
    if membershipType == '1' and hasattr(container, 'nodeName'):
        name = container.name+":!:"+container.nodeName
    return container.wasConfigIdType == wasToContainerTypeMap[membershipType] and memberString == name

def inspectContainer(container, healthPolicyName, membership):
    memberId = container.id + "/" + healthPolicyName + " membership"
    if containerMatches(container, membership['type'], membership['memberString']):
        inspectHealthPolicyMembership(memberId, healthPolicyName)

print "Start inspecting at container: '%s'" % container.name
healthPoliciesList = wsadminToList(AdminTask.listHealthPolicies())
containerList = findAllContainers(container)

for healthPolicy in healthPoliciesList:
    healthPolicyName = AdminConfig.showAttribute(healthPolicy, 'name')
    print "Inspecting healthPolicy '%s'" % healthPolicyName

    for m in findTargetMembershipIds(healthPolicy):
        membership = wsadminToDict(AdminConfig.showall(m))
        print "Health policy %s. %s" % (healthPolicyName, membership)
        for container in containerList:
            inspectContainer(container, healthPolicyName, membership)
