#
def findSIBusMember(deployed):
    for busId in wsadminToList(AdminConfig.list("SIBus")):
        if deployed.bus != AdminConfig.showAttribute(busId, 'name'): continue

        for memberId in wsadminToList(AdminConfig.showAttribute(busId, "busMembers")):
            server = AdminConfig.showAttribute(memberId, "server")
            node = AdminConfig.showAttribute(memberId, "node")
            cluster = AdminConfig.showAttribute(memberId, "cluster")
            mqServer = AdminConfig.showAttribute(memberId, "mqServer")
            if deployed.server == server and deployed.node == node and deployed.cluster == cluster and deployed.wmqServer == mqServer:
                return memberId

memberId = findSIBusMember(deployed)
if memberId:
    print "Destroying SIBusMember '%s' in SIBus '%s'" % (deployed.name, deployed.bus)
    props = deployed.getExposedProperties(True)
    for key in props.keys():
        if key not in ["bus", "server", "node", "cluster", "wmqServer"]:
            del props[key]
    AdminTask.removeSIBusMember(toAdminTaskArgs(props))
else:
    print "No SIBusMember '%s' found, nothing to do" % deployed.name
