import time

def getCluster(clusterName):
    cluster = AdminControl.completeObjectName('type=Cluster,name=%s,*' % (clusterName))
    if not cluster or len(cluster) == 0:
        print "ERROR: Unable to find cluster '%s'" % (clusterName)
        raise Exception("Unable to find cluster '%s'" % (clusterName))
    return cluster

def clusterIsRunning(cluster):
    state = AdminControl.getAttribute(cluster, 'state')
    return state == "websphere.cluster.running"

def startCluster(clusterName, rippleStart, retryInterval, numOfRetries=20):
    cluster = getCluster(clusterName)
    state = AdminControl.getAttribute(cluster, 'state')
    print "INFO: Cluster '%s' is in state: '%s'" % (clusterName, state)
    if state == "websphere.cluster.running":
        if rippleStart:
            print "INFO: Ripple starting Cluster '%s'" % (clusterName)
            AdminControl.invoke(cluster, 'rippleStart')
        else:
            print "WARN: Cluster '%s' already running. Nothing to do." % (clusterName)
    else:
        if rippleStart:
            print "INFO: Starting Cluster '%s' via ripple start" % (clusterName)
            AdminControl.invoke(cluster, 'rippleStart')
        else:
            print "INFO: Starting Cluster '%s'" % (clusterName)
            AdminControl.invoke(cluster, 'start')
    numAttempts = 1
    while not clusterIsRunning(cluster) and (numAttempts <= numOfRetries):
        print("Current state = %s" % AdminControl.getAttribute(cluster, 'state'))
        print "\nAttempt %s: Waiting for '%s' cluster to start." % (numAttempts, clusterName)
        time.sleep(retryInterval)
        numAttempts = numAttempts + 1
    if clusterIsRunning(cluster):
        print "INFO: Started cluster '%s'" % (clusterName)
    else:
        print "ERROR: Unable to start cluster after %s attempts" % (numAttempts)
        sys.exit(1)

# as per 7.0, can also use AdminClusterManagement.startSingleCluster() - see
# http://publib.boulder.ibm.com/infocenter/wasinfo/fep/index.jsp?topic=%2Fcom.ibm.websphere.nd.multiplatform.doc%2Finfo%2Fae%2Fae%2Frxml_7libadmincluster.html

try:
    cluster = container
except NameError:
    cluster = deployed

clusterName = cluster.name
print "clusterName: '%s'" % (clusterName)

rippleStart = cluster.enableRippleStart
retryInterval = cluster.checkStartedInterval

clusterMembers = AdminClusterManagement.listClusterMembers(clusterName)

if clusterMembers:
    print "Cluster members are:"
    print clusterMembers
    startCluster(clusterName, rippleStart, retryInterval)
else:
    # Add cluster members
    #     clusterMembers = { "Infrastructure/was85_nd/vagrantCell01/vagrantNode01/existing-server" }
     print "No cluster members, cannot start cluster. Skipping start."