#
def getServerId(nodeName, serverName):
    serverIds = [serverId for serverId in wsadminToList(AdminConfig.list('Server')) if serverId.find("/%s/servers/%s|" % (nodeName, serverName)) > -1]
    validateNotEmpty(serverIds, "Unable to locate server for node: '%s' and server: '%s'" % (nodeName, serverName))
    return serverIds[0]

def getCoreGroup(deployed, container):
    coreGroupContainmentPath = '%s/CoreGroup:%s' % (container.containmentPath, deployed.name)
    return AdminConfig.getid(coreGroupContainmentPath)

def getCoreGroupServer(deployed, server):
    coreGroupServerContainmentPath = "%s/CoreGroup:%s/CoreGroupServer:%s" % (deployed.container.containmentPath, deployed.name, server.name)
    coreGroupServers = wsadminToList(validateNotEmpty(AdminConfig.getid(coreGroupServerContainmentPath), "Cannot find Core Group server '%s'" % coreGroupServerContainmentPath))
    if len(coreGroupServers) == 1:
        return coreGroupServers[0]
    else:
        for coreGroupServerId in coreGroupServers:
            if server.nodeName == AdminConfig.showAttribute(coreGroupServerId, "nodeName"):
                return coreGroupServerId

def returnServersToDefaultGroup(deployed, coreGroupId, filterCallback=None):
    defaultCoreGroup = AdminTask.getDefaultCoreGroupName()
    for coreGroupServerId in wsadminToList(AdminConfig.showAttribute(coreGroupId, "coreGroupServers")):
        nodeName = AdminConfig.showAttribute(coreGroupServerId, "nodeName")
        serverName = AdminConfig.showAttribute(coreGroupServerId, "serverName")
        serverId = getServerId(nodeName, serverName)
        clusterName = AdminConfig.showAttribute(serverId, "clusterName")
        if not filterCallback or filterCallback(nodeName, serverName, clusterName):
            if clusterName:
                print "Returning cluster '%s' to default Core Group '%s'" % (clusterName, defaultCoreGroup)
                AdminTask.moveClusterToCoreGroup("[-source %s -target %s -clusterName %s]" % (deployed.name, defaultCoreGroup, clusterName))
            else:
                print "Returning server '%s' to default Core Group '%s'" % (serverName, defaultCoreGroup)
                AdminTask.moveServerToCoreGroup("[-source %s -target %s -nodeName %s -serverName %s]" % (deployed.name, defaultCoreGroup, nodeName, serverName))