########################################################################################################################
#
# Function to discover and inspect jms objects (queues, connections factories) in all scopes.
#
# canHandleJmsTypeCallback : if the caller can handle the specific jms object.
#     jmsObjectId - WAS id
#
# jmsInspectCallback : the inspection function that should be used. Default is the inspectJmsObject function in this lib.
#     deployedId - id of discovered ci.
#     jmsName - name of the jms object
#     jmsId - WAS id for the jms object
#     container - Deployit container on which the jms object resides.
#
########################################################################################################################

def discoverAndInspectJmsObjects(canHandleJmsTypeCallback=None, jmsInspectCallback=None, deployToContainer=None, protoType=None):
    if jmsInspectCallback is None:
        jmsInspectCallback = inspectJmsObject
    for c in findAllContainers(container):
        discoverAndInspectJmsObjectsInContainer(c, canHandleJmsTypeCallback, jmsInspectCallback, prototype)

def discoverAndInspectJmsObjectsInContainer(container, canHandleJmsTypeCallback, jmsInspectCallback, prototype):
    jmsObjects = wsadminToList(AdminConfig.getid('%s/JMSProvider:/%s:/' % (container.containmentPath, prototype.wasType)))
    for jmsObject in jmsObjects:
        if canHandleJmsTypeCallback is None or canHandleJmsTypeCallback(jmsObject):
            name = AdminConfig.showAttribute(jmsObject, 'name')
            deployedId = container.id + '/' + name
            discovered(deployedId, prototype.type)
            if hasattr(prototype, 'genericJmsDestinationType'):
                provider = AdminConfig.showAttribute(jmsObject, 'provider')
                inspectedProperty(deployedId, 'provider', AdminConfig.showAttribute(provider, 'name'))
            jmsInspectCallback(deployedId, name, jmsObject, container, prototype)
            inspectedItem(deployedId)

def inspectJmsObject(deployedId, jmsName, jmsId, container, prototype):
    inspectDeployedProperties(deployedId, jmsName, jmsId, prototype)
    inspectNestedJ2EEResourceProperties(deployedId, jmsId, "propertySet", "customProperties")

def createJmsObject(args, provider, deployed):
    jmsProviderContainmentPath = '%s/JMSProvider:%s' % (deployed.container.containmentPath, provider)
    jmsProviderId = validateNotEmpty(AdminConfig.getid(jmsProviderContainmentPath), "Cannot locate WebSphere JMS Provider '%s' in container '%s'" % (provider, deployed.container.name))
    print "Creating '%s' for JMS provider '%s' with args '%s' in container '%s'" % (deployed.wasType, jmsProviderId, args, deployed.container.name)
    jmsId = adminConfigCreate(deployed.wasType, jmsProviderId, args)
    if hasattr(deployed, 'customProperties'):
        createJ2EEResourceProperties(jmsId, deployed)

def destroyJmsObject(provider, deployed):
    containmentPath = '%s/JMSProvider:%s/%s:%s' % (deployed.container.containmentPath, provider, deployed.wasType, deployed.name)
    id = validateNotEmpty(AdminConfig.getid(containmentPath), "Cannot locate containment path '%s'" % (containmentPath))
    print "Destroying '%s' '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name)
    AdminConfig.remove(id)

def modifyJmsObject(deployed, provider, exposedProperties=None):
    if not exposedProperties:
        exposedProperties = deployed.getExposedProperties(True)
    if 'providerType' in exposedProperties.keys():
        print "Ignoring property 'providerType' which is a read-only attribute."
        del exposedProperties['providerType']
    args = toAdminConfigArgs(exposedProperties)
    jmsProviders = validateNotEmpty(wsadminToList(AdminConfig.getid('%s/JMSProvider:/%s:/' % (deployed.container.containmentPath, deployed.wasType))), "Cannot locate WebSphere JMS Provider '%s'" % (provider))
    jmsProviderIdList = [id for id in jmsProviders if AdminConfig.showAttribute(id, 'name') == deployed.name]

    print "Modifying '%s' for JMS provider '%s' with args '%s' in container '%s'" % (deployed.wasType, provider, args, deployed.container.name)
    if getVersion(deployed.container) == 'WAS_61':
        unsetAttributes(jmsProviderIdList[0], exposedProperties.keys())
        adminConfigModify(jmsProviderIdList[0], args)
    else:
        AdminConfig.unsetAttributes(jmsProviderIdList[0], exposedProperties.keys())
        AdminConfig.resetAttributes(jmsProviderIdList[0], args)
    removeJ2EEResourceProperties(jmsProviderIdList[0])
    if hasattr(deployed, 'customProperties'):
        createJ2EEResourceProperties(jmsProviderIdList[0], deployed)
