# Discover was.VirtualHost instances - skip VirtualHost that live on a Node
virtualhosts = AdminConfig.list('VirtualHost')
if virtualhosts != "":
    for virtualhost in virtualhosts.splitlines():
        if virtualhost.find('/nodes/') == -1:
            virtualHostName = AdminConfig.showAttribute(virtualhost, 'name')
            virtualHostId = '%s/%s' % (container.id, virtualHostName)
            discovered(virtualHostId, 'was.VirtualHost')
            virtualHostContainmentPath = '/Cell:%s/VirtualHost:%s' % (container.cellName, virtualHostName)
            virtualHostAliases = AdminConfig.getid(virtualHostContainmentPath + '/HostAlias:/').split()
            inspectedProperty(virtualHostId, 'aliases', [AdminConfig.showAttribute(a, 'hostname') + ':' + AdminConfig.showAttribute(a, 'port') for a in virtualHostAliases if a != ""])
            inspectedItem(virtualHostId)
