
resourceEnvProviderContainmentPath = '%s/ResourceEnvironmentProvider:/' % (deployed.container.containmentPath)
resourceEnvProviders = validateNotEmpty(wsadminToList(AdminConfig.getid(resourceEnvProviderContainmentPath)), "Cannot locate Resource Environment Provider ContainmentPath '%s'" % (resourceEnvProviderContainmentPath))
resourceEnvProviderIds = [id for id in resourceEnvProviders if AdminConfig.showAttribute(id, 'name') == deployed.name]
if not resourceEnvProviderIds:
    printErrorAndExit("Cannot locate Resource Environment Provider '%s' in container '%s'" % (deployed.name, deployed.container.name))
resourceEnvProviderId = resourceEnvProviderIds[0]

exposedProperties = deployed.getExposedProperties(True)
if not exposedProperties['description']:
    exposedProperties['description'] = ''

args = appendReferenceables(toAdminConfigArgs(exposedProperties))
for referenceableId in wsadminToList(AdminConfig.showAttribute(resourceEnvProviderId, "referenceables")):
    AdminConfig.remove(referenceableId)

print "Modifying Resource Environment Provider '%s' in container '%s' with args '%s'" % (resourceEnvProviderId, deployed.container.name, args)
resEnvEntryId = adminConfigModify(resourceEnvProviderId, args)

removeJ2EEResourceProperties(resourceEnvProviderId)
if hasattr(deployed, 'customProperties'):
    createJ2EEResourceProperties(resourceEnvProviderId, deployed)
