package com.xebialabs.deployit.plugin.was.upgrade;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.xebialabs.deployit.server.api.repository.RawRepository;
import com.xebialabs.deployit.server.api.upgrade.Upgrade;
import com.xebialabs.deployit.server.api.upgrade.UpgradeException;
import com.xebialabs.deployit.server.api.upgrade.Version;


public class WAS410UnmanagedWebServerMigration extends Upgrade {

    @Override
    public boolean doUpgrade(RawRepository repository) throws UpgradeException {
        logger.info("*** Starting WAS plugin 4.1.0 upgrade -- Migrate UnmanagedWebServer type ***");

        try {
            repository.renameType("wasx.UnmanagedWebServer", "was.UnmanagedWebServer");
        } catch (Exception e) {
            throw new UpgradeException("*** Failed WAS plugin 4.1.0 upgrade -- Migrate UnmanagedWebServer type ***", e);
        }

        logger.info("*** Done WAS plugin 4.1.0 upgrade -- Migrate UnmanagedWebServer type ***");
        return true;
    }

    @Override
    public Version upgradeVersion() {
        return Version.valueOf("was-plugin","4.1.0");
    }

    private static final Logger logger = LoggerFactory.getLogger(WAS410UnmanagedWebServerMigration.class);

}

