def discoverAndInspectCustomService(container):
    customServiceContainmentPath = '%s/CustomService:/' % (container.containmentPath)
    customServices = wsadminToList(AdminConfig.getid(customServiceContainmentPath))
    for customService in customServices:
        deployedName = AdminConfig.showAttribute(customService, 'displayName')
        deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectDeployedProperties(deployedId, deployedName, customService, prototype)
        inspectNestedCustomProperties(deployedId, customService, "properties", "customProperties")
        inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectCustomService(c)