
print "Inspecting container: '%s'" % container.name
siBusList = wsadminToList(AdminTask.listSIBuses())

for bus in siBusList:
    busProps = getBusProperties(bus)
    print "Inspecting Service Integration Bus '%s' of type '%s'" % (busProps['busName'], prototype.type)

    busId = container.id + '/' + busProps['busName']

    discovered(busId, prototype.type)

    for k, v in busProps.items():
        if k not in ['secure', 'busName']:
            inspectedProperty(busId, k, v)

    permittedTransports = getPermittedTransports(busProps['busName'])
    for k in permittedTransports.keys():
        inspectedProperty(busId, 'permittedTransport_'+deCapitalize(k), 'true')

    inspectedItem(busId)
