#
def toNestedAdminConfigArgs(deployed):
    props = deployed.getExposedProperties(True)
    nestedProps = deployed.getNestedObjects()
    for nestedName in nestedProps.keys():
        del props[nestedName]
    supportedAttrs = None
    if hasattr(deployed, "wasType") and deployed.wasType:
        props = excludeUnsupportedProperties(deployed.wasType, props)
        supportedAttrs = getConfigTypeAttrs(deployed.wasType)
    args = []
    for nestedName, nestedValue in nestedProps.items():
        attributeName = nestedName[0].lower() + nestedName[1:]
        if supportedAttrs and attributeName not in supportedAttrs:
            print "WARN: Complex property '%s' of type '%s' is ignored for the current WAS Server version" % (attributeName, deployed.wasType)
        else:
            args.extend([[attributeName, toNestedAdminConfigArgs(nestedValue)]])
    args.extend(toAdminConfigArgs(props))
    return args

def getTransportChannelService(serverId):
    return wsadminToList(validateNotEmpty(AdminConfig.list("TransportChannelService", serverId), "Cannon find TransportChannelService in container %s" % serverId))[0]

def getPort(portName, container):
    nodePath = '/Cell:%s/Node:%s/' % (container.cellName, container.nodeName)
    nodeId = validateNotEmpty(AdminConfig.getid(nodePath), "Cannon find node '%s' for path '%s'" % (container.nodeName, nodePath))
    for endpointId in wsadminToList(AdminConfig.list("NamedEndPoint", nodeId)):
        if AdminConfig.showAttribute(endpointId, "endPointName") == portName:
            return endpointId

################################################################################################################
# Transport chain functions
################################################################################################################
def createOrModifyChain(container, chain):
    serverId = validateNotEmpty(AdminConfig.getid(container.containmentPath), "Cannon find server for path %s" % container.containmentPath)
    channelServiceId = getTransportChannelService(serverId)
    chainId = findChain(chain.name, channelServiceId)
    if not chainId:
        print "No existing transport chain with name '%s' found in container '%s'. Creating new instance." % (chain.name, container.name)
        chainId = createChain(container, chain, channelServiceId)
    modifyChain(container, chain, chainId, channelServiceId)

def findChain(chainName, channelServiceId):
    for chainId in wsadminToList(AdminConfig.list("Chain", channelServiceId)):
        if AdminConfig.showAttribute(chainId, "name") == chainName:
            return chainId

def createChain(container, chain, channelServiceId):
    if chain.templateName:
        validateNotEmpty(chain.portName, "Property portName must be specified when transport chain is created from chain template")
        templateIds = [templateId for templateId in wsadminToList(AdminTask.listChainTemplates()) if AdminConfig.showAttribute(templateId, "name") == chain.templateName]
        templateId = validateNotEmpty(templateIds, "Cannot find any transport chain template matching template name '%s'" % chain.templateName)[0]
        portId = validateNotEmpty(getPort(chain.portName, container), "Cannot find port name '%s'" % chain.portName)
        args = toAdminTaskArgs({"name": chain.name, "template": templateId, "endPoint": portId})
        print "Creating transport chain '%s' in container '%s' with args '%s'" % (chain.name, container.name, args)
        return AdminTask.createChain(channelServiceId, args)
    else:
        args = toAdminConfigArgs({"name": chain.name})
        print "Creating transport chain '%s' in container '%s' with args '%s'" % (chain.name, container.name, args)
        return AdminConfig.create("Chain", channelServiceId, args)

def modifyChain(container, chain, chainId, channelServiceId):
    transportChannelIds = []
    for transportChannel in chain.transportChannels:
        transportChannelId = createOrModifyChannel(container, transportChannel)
        transportChannelIds.append(transportChannelId)
    args = toAdminConfigArgs(chain.getExposedProperties(True))
    args.append(["transportChannels", transportChannelIds])
    print "Modify transport chain '%s' in container '%s' with args '%s'" % (chain.name, container.name, args)
    return AdminConfig.modify(chainId, args)

def destroyChain(container, chain):
    serverId = validateNotEmpty(AdminConfig.getid(container.containmentPath), "Cannon find server for path %s" % container.containmentPath)
    channelServiceId = getTransportChannelService(serverId)
    chainId = findChain(chain.name, channelServiceId)
    print "Destroying transport chain '%s' in container '%s'" % (chain.name, container.name)
    AdminTask.deleteChain(chainId, ['-deleteChannels', 'true'])

################################################################################################################
# Transport channel functions
################################################################################################################
def createOrModifyChannel(container, channel):
    serverId = validateNotEmpty(AdminConfig.getid(container.containmentPath), "Cannon find server for path %s" % container.containmentPath)
    channelServiceId = getTransportChannelService(serverId)
    args = toNestedAdminConfigArgs(channel)
    channelId = findChannel(channel.name, channel.wasType, channelServiceId)
    if not channelId:
        print "Creating transport channel '%s' in container '%s' with args '%s'" % (channel.name, container.name, args)
        channelId = AdminConfig.create(channel.wasType, channelServiceId, args)
    else:
        print "Modify transport channel '%s' in container '%s' with args '%s'" % (channel.name, container.name, args)
        AdminConfig.modify(channelId, args)

    removeCustomProps(channelId, "properties")
    createCustomProps(channelId, "Property", channel)

    return channelId

def findChannel(channelName, channelType, channelServiceId):
    for channelId in wsadminToList(AdminConfig.list(channelType, channelServiceId)):
        if AdminConfig.showAttribute(channelId, "name") == channelName:
            return channelId

