#
targetId = getTarget(deployed, deployed.container)

existing = {}
for entry in getProperties(deployed, deployed.container, targetId):
    name = AdminConfig.showAttribute(entry, "name")
    existing[name] = entry

for key, value in deployed.properties.items():
    if not existing.has_key(key):
        print "Custom property '%s' already removed." % key
    else:
        if deployed.overwriteExisting:
            print "Removing custom property '%s'" % (key)
            AdminConfig.remove(existing[key])
        else:
            currentValue = AdminConfig.showAttribute(existing[key], "value")
            if currentValue == value:
                print "Removing custom property '%s'" % (key)
                AdminConfig.remove(existing[key])
            else:
                newValue = currentValue.replace(value, "", 1)
                print "Removing '%s' from custom property %s. New value = %s" % (value, key, newValue)
                attr = [["name", key], ["value", newValue]]
                AdminConfig.modify(existing[key], attr)