#
################################################################################################################
# Server configuration utility functions
################################################################################################################
def excludeUnsupportedTypes(types):
    wasTypes = wsadminToList(AdminConfig.types())
    supportedTypes = []
    for type in types:
        if type in wasTypes:
            supportedTypes.append(type)
        else:
            print "WARN: All properties of type '%s' are ignored for the current WAS Server version" % type
    return supportedTypes

def getApplicationServers(container):
    return wsadminToList(AdminConfig.getid('%s/ApplicationServer:/' % container.containmentPath))

def getApplicationServer(container):
    appServerIds = getApplicationServers(container)
    validateNotEmpty(appServerIds, "Cannot find any applications servers in container '%s'" % container.name)
    return appServerIds[0]

################################################################################################################
# Default callback functions
################################################################################################################
def defaultConfigurePropertiesCallback(objectInst, objectType, objectId, attributeName="properties"):
    if hasattr(objectInst, "customProperties"):
        if objectInst.customProperties:
            if hasattr(deployed, "overwriteExistingCustomProperties") and deployed.overwriteExistingCustomProperties:
                removeCustomProps(objectId, attributeName)
                createCustomProps(objectId, "Property", objectInst)
            else:
                createOrUpdateCustomProps(objectId, "Property", objectInst)
        else:
            if hasattr(deployed, "overwriteExistingValues") and deployed.overwriteExistingValues:
                removeCustomProps(objectId, attributeName)

def defaultInspectConfigResourceCallback(deployedId, resourceId, propertyPrefix):
    if hasattr(prototype, "customProperties") and not propertyPrefix:
        inspectCustomProperties(deployedId, wsadminToList(AdminConfig.showAttribute(resourceId, "properties")), "customProperties")

################################################################################################################
# Configure functions
################################################################################################################
def configureConfigResource(deployed, configurePropertiesCallback=defaultConfigurePropertiesCallback):
    serverId = AdminConfig.getid(deployed.container.containmentPath)
    configureNestedConfigResources(deployed, deployed.name, deployed.wasType, deployed.container.name, serverId, configurePropertiesCallback)

def configureNestedConfigResources(objectInst, objectName, objectType, parentName, parentId, configurePropertiesCallback=None):
    props = objectInst.getExposedProperties(True)
    nestedProps = objectInst.getNestedObjects()
    for nested in nestedProps.keys():
        del props[nested]
    objectId = configureConfigResourceProperties(objectInst, objectName, objectType, parentName, parentId, props, configurePropertiesCallback)
    for nestedName in excludeUnsupportedTypes(nestedProps.keys()):
        configureNestedConfigResources(nestedProps[nestedName], nestedName, nestedName, parentName, objectId, configurePropertiesCallback)

def configureConfigResourceProperties(objectInst, objectName, objectType, parentName, parentId, props, configurePropertiesCallback=None):
    if not props:
        return None
    objectIds = wsadminToList(AdminConfig.list(objectType, parentId))
    if len(objectIds) == 0:
        print "Cannot find %s '%s' in container '%s'. Creating new instance." % (objectType, objectName, parentId)
        objectId = AdminConfig.create(objectType, parentId, [])
    else:
        objectId = objectIds[0]
    setConfigResourceProperties(objectId, objectName, objectType, parentName, props)
    if configurePropertiesCallback:
        configurePropertiesCallback(objectInst, objectType, objectId)
    return objectId

def setConfigResourceProperties(objectId, objectName, objectType, parentName, props):
    props = excludeUnsupportedProperties(objectType, props)
    args = []
    if getVersion(deployed.container) == 'WAS_61':
        if hasattr(deployed, "overwriteExistingValues") and deployed.overwriteExistingValues:
            unsetAttributes(objectId, props.keys())
        args = toAdminConfigArgs(props)
        if args:
            AdminConfig.modify(objectId, args)
    else:
        if hasattr(deployed, "overwriteExistingValues") and deployed.overwriteExistingValues:
            AdminConfig.unsetAttributes(objectId, props.keys())
        args = toAdminConfigArgs(props)
        if args:
            AdminConfig.resetAttributes(objectId, args)
    print "Configuring settings of %s in container '%s' with args '%s'" % (objectName, parentName, args)

################################################################################################################
# Discover inspect functions
################################################################################################################
def discoverInspectConfigResourcesInContainers(container, prototype, inspectConfigResourceCallback=defaultInspectConfigResourceCallback, discoverConfigResourceCallback=None, inspectableContainerType="Server"):
    for c in findAllContainers(container):
        if not hasattr(prototype, "wasContainerTypes") or c.wasConfigIdType in prototype.wasContainerTypes:
            if discoverConfigResourceCallback:
                objectIds = discoverConfigResourceCallback(c, prototype)
            else:
                objectIds = wsadminToList(AdminConfig.list(prototype.wasType, AdminConfig.getid(c.containmentPath)))
            for objectId in objectIds:
                name = prototype.defaultDiscoverName
                print "Discovered %s '%s' in container '%s'" % (prototype.type, name, c.name)
                deployedId = c.id + '/' + name
                discovered(deployedId, prototype.type)
                discoverInspectNestedConfigResources(deployedId, prototype, objectId, "", inspectConfigResourceCallback)
                inspectedItem(deployedId)

def discoverInspectNestedConfigResources(deployedId, objectInst, objectId, propertyPrefix="", inspectConfigResourceCallback=None):
    inspectConfigResource(deployedId, objectId, propertyPrefix, inspectConfigResourceCallback)
    nestedObjects = objectInst.getNestedObjects()
    for nestedName in excludeUnsupportedTypes(nestedObjects.keys()):
        for nestedObjectId in wsadminToList(AdminConfig.list(nestedName, objectId)):
            discoverInspectNestedConfigResources(deployedId, nestedObjects[nestedName], nestedObjectId, "%s%s_" % (propertyPrefix, nestedName), inspectConfigResourceCallback)

def inspectConfigResource(deployedId, resourceId, propertyPrefix="", inspectConfigResourceCallback=None):
    if not resourceId: return
    attributes = wsadminToDict(AdminConfig.show(resourceId))
    for attrName, attrValue in attributes.items():
        if attrValue == '[]': attrValue = []
        inspectedProperty(deployedId, "%s%s" % (propertyPrefix, attrName), attrValue)
    if inspectConfigResourceCallback:
        inspectConfigResourceCallback(deployedId, resourceId, propertyPrefix)
