#
def j2cConnectionFactoryProps(deployed):
    props = excludeUnsupportedProperties(deployed, deployed.getExposedProperties(True))
    providerId = getJ2CResourceAdapter(deployed)
    for connectionDefinitionId in wsadminToList(AdminConfig.list("ConnectionDefinition", providerId)):
        if AdminConfig.showAttribute(connectionDefinitionId, "connectionFactoryInterface") == deployed.connectionFactoryInterface:
            props["connectionDefinition"] = connectionDefinitionId
    return props

def createJ2CConnectionFactory(props, deployed):
    args = toAdminConfigArgs(props)
    providerId = getJ2CResourceAdapter(deployed)
    print "Creating %s for resource adapter '%s' with args '%s' in container '%s'" % (deployed.wasType, deployed.provider, args, deployed.container.name)
    connectionFactoryId = AdminConfig.create(deployed.wasType, providerId, args)
    createJ2CConnectionFactoryNestedObjects(connectionFactoryId, deployed)

def createJ2CConnectionFactoryNestedObjects(parentId, deployed):
    createOrModifyMappingModule(parentId, deployed)
    if hasattr(deployed, "ConnectionPool"):
        poolArgs = toAdminConfigArgs(deployed.ConnectionPool.getExposedProperties())
        configureConnectionPool(parentId, poolArgs, "connectionPool")
    if hasattr(deployed, "customProperties"):
        createOrUpdateJ2EEResourceProperties(parentId, deployed)

def inspectJ2CConnectionFactory(deployedId, deployedName, resourceId, prototype):
    ignoredProps = getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys())
    ignoredProps.append("name")
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype, ignoredProps)

    providerId = AdminConfig.showAttribute(resourceId, "provider")
    inspectedProperty(deployedId, "provider", AdminConfig.showAttribute(providerId, "name"))

    connectionDefinitionId = AdminConfig.showAttribute(resourceId, "connectionDefinition")
    inspectedProperty(deployedId, "connectionFactoryInterface", AdminConfig.showAttribute(connectionDefinitionId, "connectionFactoryInterface"))
    inspectJ2CConnectionFactoryNestedObjects(deployedId, deployedName, resourceId, prototype)

def inspectJ2CConnectionFactoryNestedObjects(deployedId, deployedName, resourceId, prototype):
    if AdminConfig.showAttribute(resourceId, "connectionPool"):
        discoverConnectionFactoryNestedObjects(deployedId, resourceId, "ConnectionPool_", "connectionPool")
    if AdminConfig.showAttribute(resourceId, "mapping"):
        discoverConnectionFactoryMappingObjects(deployedId, resourceId, "mapping")
    inspectNestedJ2EEResourceProperties(deployedId, resourceId, "propertySet", "customProperties")
