def discoverAndInspectSibTopicSpaces(container):
    if container.type != 'was.DeploymentManager' and container.type != 'was.UnmanagedServer':
        return
    
    sibuses = AdminTask.listSIBuses()
    if sibuses == "":
        return
    
    for sibus in sibuses.splitlines():
        busName = AdminConfig.showAttribute(sibus, 'name')
        topicSpaces = AdminTask.listSIBDestinations(['-bus', busName, '-type', 'TopicSpace'])
        if topicSpaces != "":
            for topicSpace in topicSpaces.splitlines():
                discoverAndInspectSibTopicSpace(container, busName, topicSpace)

def discoverAndInspectSibTopicSpace(container, busName, topicSpace):
    topicSpaceName = AdminConfig.showAttribute(topicSpace, 'identifier')
    topicSpaceId = container.id + '/' + topicSpaceName
    discovered(topicSpaceId, prototype.type)
    inspectedProperty(topicSpaceId, 'busName', busName)
    inspectedItem(topicSpaceId)
    
for c in findAllContainers(container):
    discoverAndInspectSibTopicSpaces(c)

