def dynamicClusterArgs(container):
    dynClusterArgs = "[operationalMode %s]" %(container.operationalMode.lower())
    if hasattr(container, 'minInstances') and container.minInstances is not None:
        dynClusterArgs = "%s[minInstances %s]" %(dynClusterArgs, str(container.minInstances))
    if hasattr(container, 'maxInstances') and container.maxInstances is not None:
        dynClusterArgs = "%s[maxInstances %s]" %(dynClusterArgs, str(container.maxInstances))
    if hasattr(container, 'numVerticalInstances') and container.numVerticalInstances is not None:
        dynClusterArgs = "%s[numVerticalInstances %s]" %(dynClusterArgs, str(container.numVerticalInstances))
    args = '-membershipPolicy \"%s\" -dynamicClusterProperties \"[%s]"' %(container.membershipPolicy, dynClusterArgs)
    if hasattr(container, 'memberTemplateName') and container.memberTemplateName is not None:
        args = '%s -clusterProperties "[[templateName %s]]"' %(args, container.memberTemplateName)
    return args
