#
goalAttributeUnits = ['timePeriodValueUnits', 'goalDeltaValueUnits', 'goalValueUnits']
goalAttributeImportanceMap = {"1":"HIGHEST", "15":"VERY_HIGH", "50":"MEDIUM", "65":"LOW", "85":"VERY_LOW", "99":"LOWEST", "35":"HIGH"}
resolveUnitsMap = {"0":"MILLISECONDS","1":"SECONDS"}
avgResponseTime = ["goalPercent","goalDeltaPercent"]
goalAttributesStringToIntMap = {"HIGHEST":"1", "VERY_HIGH":"15", "MEDIUM":"50", "LOW":"65", "VERY_LOW":"85", "LOWEST":"99", "HIGH":"35", "MILLISECONDS":"0", "SECONDS":"1"}

def createAdditionalTransactionClasses(servicePolicyId):
    for transactionClassName in deployed.additionalTransactionClasses:
        tcArgs = [['name', transactionClassName]]
        print "Creating additional transaction class %s for %s: %s" % (transactionClassName, deployed.name, tcArgs)
        AdminConfig.create("TransactionClass", servicePolicyId, tcArgs)

def createPolicyAttributes(servicePolicyId):
    goalAttributes = deployed.GoalAttributes.getExposedProperties(True)
    for key in goalAttributes.keys():
        if goalAttributes[key] in goalAttributesStringToIntMap.keys():
            goalAttributes[key] = goalAttributesStringToIntMap[goalAttributes[key]]

    if deployed.goalType == 'DISCRETIONARY':
        discretionaryGoalAttributes = {}
        if getVersion(deployed.container) != 'WAS_61':
            # importance is not supported in 6.1
            if 'importance' in goalAttributes.keys():
                discretionaryGoalAttributes['importance'] = goalAttributes['importance']
        goalArgs = toAdminConfigArgs(discretionaryGoalAttributes)
        print "Creating DiscretionaryGoal for %s: %s" % (deployed.name, goalArgs)
        AdminConfig.create("DiscretionaryGoal", servicePolicyId, goalArgs)

    elif deployed.goalType == 'AVERAGE_RESPONSE_TIME':
        for goalAttrs in avgResponseTime:
            if goalAttrs in goalAttributes.keys():
                print "Ignoring property '%s' which is not supported for Average Response Time goals" %(goalAttrs)
                del goalAttributes[goalAttrs]
        goalArgs = toAdminConfigArgs(goalAttributes)
        print "Creating Average Response Time goal for %s: %s" % (deployed.name, goalArgs)
        AdminConfig.create("AverageResponseTimeGoal", servicePolicyId, goalArgs)

    elif deployed.goalType == 'PERCENTILE_RESPONSE_TIME':
        goalArgs = toAdminConfigArgs(goalAttributes)
        print "Creating Percentile Response Time goal for %s: %s" % (deployed.name, goalArgs)
        AdminConfig.create("PercentileResponseTimeGoal", servicePolicyId, goalArgs)