/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.controltask;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PythonScriptControlTaskDelegate
implements Serializable {
    @Delegate(name="pythonControlTask")
    public static List<Step> invokeDispatcher(ConfigurationItem ci, String methodName, Map<String, String> arguments, Parameters parameters) {
        String script = arguments.get("script");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)script) ? 1 : 0) != 0, (Object)"Argument 'script' is required.");
        ConfigurationItem container = ci;
        if (ci instanceof Container) {
            container = ci;
        } else if (ci instanceof PythonManagedDeployed) {
            container = ((PythonManagedDeployed)ci).getContainer();
        }
        String itemVarContextName = ci instanceof Container ? "container" : "deployed";
        LinkedHashMap thisVarContext = Maps.newLinkedHashMap();
        thisVarContext.put(itemVarContextName, ci);
        String scriptName = ConfigurationHolder.resolveExpression((String)script, (Object)thisVarContext);
        thisVarContext.put("arguments", arguments);
        thisVarContext.put("parameters", parameters);
        if (container == null) {
            throw new IllegalArgumentException(String.format("Control task '%s' with python script '%s' can only be run against a ci of type python.PythonManagedDeployed or container that is a python.PythonManagingContainer or implements python.PythonManagedContaner. CI '%s' does not satisfies those conditions.", methodName, scriptName, container));
        }
        PythonManagingContainer pythonManagingContainer = null;
        if (container instanceof PythonManagedContainer) {
            pythonManagingContainer = ((PythonManagedContainer)container).getManagingContainer();
        } else if (container instanceof PythonManagingContainer) {
            pythonManagingContainer = (PythonManagingContainer)container;
        }
        if (pythonManagingContainer == null) {
            throw new IllegalArgumentException(String.format("Control task '%s' with python script '%s' can only be run against a container that is a python.PythonManagingContainer or implements python.PythonManagedContaner. Container '%s' does not.", methodName, scriptName, container));
        }
        String desc = "Executing " + methodName + " on " + ci;
        return Collections.singletonList(new PythonDeploymentStep(1, pythonManagingContainer, scriptName, (Map)thisVarContext, desc));
    }
}

