/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.controltask.dmgr;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.controltask.dmgr.DeploymentManagerDelegateTarget;
import com.xebialabs.deployit.plugin.was.controltask.dmgr.NodeAgentDelegate;
import com.xebialabs.deployit.plugin.was.controltask.dmgr.Operation;
import com.xebialabs.deployit.plugin.was.controltask.dmgr.StartStopDelegate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeploymentManagerDelegate
extends StartStopDelegate<DeploymentManager>
implements Serializable {
    private static final String KEY_DEPLOYMENT_MANAGER = "deploymentManager";
    private static final String PROPERTY_TARGET = "target";

    @Delegate(name="dmgrRestart")
    public List<Step> restartDmgr(ConfigurationItem dmgr, String method, Map<String, String> arguments, Parameters params) {
        ArrayList restartSteps = Lists.newArrayList();
        DeploymentManagerDelegateTarget target = (DeploymentManagerDelegateTarget)((Object)params.getProperty(PROPERTY_TARGET));
        restartSteps.addAll(this.createDmgrSteps((DeploymentManager)dmgr, Operation.STOP, target));
        restartSteps.addAll(this.createDmgrSteps((DeploymentManager)dmgr, Operation.START, target));
        return restartSteps;
    }

    @Delegate(name="dmgrStart")
    public List<Step> startDmgr(ConfigurationItem dmgr, String method, Map<String, String> arguments, Parameters params) {
        DeploymentManagerDelegateTarget target = (DeploymentManagerDelegateTarget)((Object)params.getProperty(PROPERTY_TARGET));
        return this.createDmgrSteps((DeploymentManager)dmgr, Operation.START, target);
    }

    @Delegate(name="dmgrStop")
    public List<Step> stopDmgr(ConfigurationItem dmgr, String method, Map<String, String> arguments, Parameters params) {
        DeploymentManagerDelegateTarget target = (DeploymentManagerDelegateTarget)((Object)params.getProperty(PROPERTY_TARGET));
        return this.createDmgrSteps((DeploymentManager)dmgr, Operation.STOP, target);
    }

    private List<Step> createDmgrSteps(DeploymentManager dmgr, Operation operation, DeploymentManagerDelegateTarget target) {
        LinkedHashSet nodeAgents = Sets.newLinkedHashSet((Iterable)Iterables.filter(dmgr.getNodes(), NodeAgent.class));
        ArrayList steps = Lists.newArrayList();
        switch (target) {
            case DEPLOYMENT_MANAGER_AND_NODE_AGENTS: {
                steps.add(this.createStep(operation, dmgr));
                steps.addAll(this.nodeAgentSteps(operation, nodeAgents));
                break;
            }
            case DEPLOYMENT_MANAGER: {
                steps.add(this.createStep(operation, dmgr));
                break;
            }
            case NODE_AGENTS: {
                steps.addAll(this.nodeAgentSteps(operation, nodeAgents));
            }
        }
        return steps;
    }

    private List<Step> nodeAgentSteps(Operation operation, Set<NodeAgent> nodeAgents) {
        ArrayList steps = Lists.newArrayList();
        NodeAgentDelegate delegate = new NodeAgentDelegate();
        for (NodeAgent nodeAgent : nodeAgents) {
            steps.add(delegate.createStep(operation, nodeAgent));
        }
        return steps;
    }

    @Override
    protected Map<String, Object> getContext(DeploymentManager dmgr) {
        HashMap ctx = Maps.newHashMap();
        ctx.put(KEY_DEPLOYMENT_MANAGER, dmgr);
        return ctx;
    }
}

