package com.xebialabs.deployit.plugin.was.controltask.dmgr;

import java.util.Map;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.overthere.HostContainer;

public abstract class StartStopDelegate<T extends HostContainer> {

    private static final String STOP_WRAPPER_SCRIPT = "was/container/stop-dmgr-nodeagents";
    private static final String START_WRAPPER_SCRIPT = "was/container/start-dmgr-nodeagents";

    protected Step createStep(Operation operation, T hostContainer) {
        Step step = null;
        switch (operation) {
        case START:
            step = startStep(hostContainer.getHost(), getContext(hostContainer), hostContainer);
            break;
        case STOP:
            step = stopStep(hostContainer.getHost(), getContext(hostContainer), hostContainer);
            break;
        }
        return step;
    }

    private Step stopStep(Host host, Map<String, Object> ctx, ConfigurationItem ci) {
        return new ScriptExecutionStep(1, getStopWrapperScript(), host, ctx, "Stopping " + ci);
    }

    private Step startStep(Host host, Map<String, Object> ctx, ConfigurationItem ci) {
        return new ScriptExecutionStep(1, getStartWrapperScript(), host, ctx, "Starting " + ci);
    }

    protected String getStopWrapperScript() {
        return STOP_WRAPPER_SCRIPT;
    }

    protected String getStartWrapperScript() {
        return START_WRAPPER_SCRIPT;
    }

    protected abstract Map<String, Object> getContext(T hostContainer);

}

enum Operation {
    STOP, START;
}