/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.controltask.dmgr;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.generic.step.SuccessStep;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import com.xebialabs.deployit.plugin.was.controltask.dmgr.Operation;
import com.xebialabs.deployit.plugin.was.controltask.dmgr.StartStopDelegate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NodeAgentDelegate
extends StartStopDelegate<NodeAgent> {
    private static final String KEY_NODE = "node";
    private static final String KEY_DEPLOYMENT_MANAGER = "deploymentManager";
    private static final String PROPERTY_WASHOME = "wasHome";
    private static final String PROPERTY_HOST = "host";

    @Delegate(name="nodeAgentStart")
    public List<Step> startNodeAgent(ConfigurationItem ci, String method, Map<String, String> arguments) {
        NodeAgent nodeAgent = (NodeAgent)ci;
        return Lists.newArrayList((Object[])new Step[]{this.createStep(Operation.START, nodeAgent)});
    }

    @Delegate(name="nodeAgentStop")
    public List<Step> stopNodeAgent(ConfigurationItem ci, String method, Map<String, String> arguments) {
        NodeAgent nodeAgent = (NodeAgent)ci;
        return Lists.newArrayList((Object[])new Step[]{this.createStep(Operation.STOP, nodeAgent)});
    }

    @Override
    protected Step createStep(Operation operation, NodeAgent nodeAgent) {
        Step step = null;
        List<String> messages = this.validate(nodeAgent);
        boolean isValid = messages.isEmpty();
        if (isValid) {
            step = super.createStep(operation, nodeAgent);
        } else {
            String details = Joiner.on((String)"").join(messages);
            String desc = String.format("Operation '%s' will not be performed on node agent '%s'. %s", new Object[]{operation, nodeAgent, details});
            step = new SuccessStep(1, desc);
        }
        return step;
    }

    private List<String> validate(NodeAgent ci) {
        ArrayList messages = Lists.newArrayList();
        this.validateString(messages, ci, PROPERTY_WASHOME);
        this.validateRef(messages, ci, PROPERTY_HOST);
        return messages;
    }

    private void validateString(List<String> messages, NodeAgent ci, String property) {
        if (!ci.hasProperty(property) || Strings.isNullOrEmpty((String)((String)ci.getProperty(property)))) {
            String msg = String.format("Property %s is required.", property);
            messages.add(msg);
        }
    }

    private void validateRef(List<String> messages, NodeAgent ci, String property) {
        Object propValue = ci.getProperty(property);
        if (!ci.hasProperty(property) || null == propValue) {
            String msg = String.format("Property %s is required.", property);
            messages.add(msg);
        }
    }

    @Override
    protected Map<String, Object> getContext(NodeAgent nodeAgent) {
        HashMap ctx = Maps.newHashMap();
        ctx.put(KEY_NODE, nodeAgent);
        ctx.put(KEY_DEPLOYMENT_MANAGER, ((NodeAgent)NodeAgent.class.cast(nodeAgent)).getCell());
        return ctx;
    }
}

