def j2cResourceAdapterProps(deployed):
    return excludeUnsupportedProperties(deployed, deployed.getExposedProperties(True))

def getGeneratedCustomProperties(deployed):
    raTemplateId = AdminConfig.getid("/Node:%s/J2CResourceAdapter:%s" % (deployed.nodeName, deployed.name))
    if raTemplateId:
        propertySetId = AdminConfig.showAttribute(raTemplateId, 'propertySet')
        if propertySetId:
            properties = {}
            for pid in wsadminToList(AdminConfig.showAttribute(propertySetId, "resourceProperties")):
                properties[AdminConfig.showAttribute(pid, "name")] = AdminConfig.showAttribute(pid, "value")
            return properties

def setJ2CResourceAdapterProperties(raId, deployed, props):
    if getVersion(deployed.container) != 'WAS_61':
        AdminConfig.unsetAttributes(raId, props.keys())
    else:
        resetProps = {}
        for pName in [pName for pName in props.keys() if pName != "name"]:
            resetProps[pName] = ""
        AdminConfig.modify(raId, toAdminConfigArgs(resetProps))
    AdminConfig.modify(raId, toAdminConfigArgs(props))

################################################################################################################
# Create, modify, destroy, inspect functions
################################################################################################################
def createJ2CResourceAdapter(deployed, props):
    args = toAdminConfigArgs(props)
    print "Creating %s with args '%s' in container '%s'" % (deployed.wasType, args, deployed.container.name)

    raTemplateId = AdminConfig.getid("/Node:%s/J2CResourceAdapter:%s" % (deployed.nodeName, deployed.name))
    if raTemplateId:
        print "J2C resource adapter '%s' already installed on node '%s'. Reusing the existing RAR." % (deployed.name, deployed.nodeName)
    else:
        options = ["-rar.name", deployed.name]
        if deployed.archivePath:
            options.extend(["-rar.archivePath", deployed.archivePath])
        raTemplateId = AdminConfig.installResourceAdapter(deployed.file, deployed.nodeName, options)

    if deployed.container.name != deployed.nodeName:
        if wsadminToList(AdminConfig.getid('%s/J2CResourceAdapter:%s' % (deployed.container.containmentPath, deployed.name))):
            printErrorAndExit("ERROR: J2C resource adapter '%s' already installed on container '%s'" % (deployed.name, deployed.container.name))
        scopeId = validateNotEmpty(AdminConfig.getid(deployed.container.containmentPath), "Cannot locate container '%s'" % (deployed.container.name))
        raId = AdminTask.copyResourceAdapter(raTemplateId, ["-name", deployed.name, "-scope", scopeId])
    else:
        raId = raTemplateId

    setJ2CResourceAdapterProperties(raId, deployed, props)
    createOrUpdateJ2EEResourceProperties(raId, deployed)

def modifyJ2CResourceAdapter(deployed, props):
    args = toAdminConfigArgs(allNoneToEmpty(props))
    raId = getJ2CResourceAdapter(deployed)
    print "Modify %s with args '%s' in container '%s'" % (deployed.wasType, args, deployed.container.name)

    setJ2CResourceAdapterProperties(raId, deployed, props)
    if deployed.customProperties:
        generatedProperties = getGeneratedCustomProperties(deployed)
        if generatedProperties:
            print "Reset custom properties to default generated values"
            removeJ2EEResourceProperties(raId)
            generatedProperties.update(deployed.customProperties)
            deployed.customProperties = generatedProperties
        createOrUpdateJ2EEResourceProperties(raId, deployed)

def destroyJ2CResourceAdapter(deployed):
    id = getJ2CResourceAdapter(deployed)
    print "Destroying %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name)
    AdminConfig.remove(id)

def inspectJ2CResourceAdapter(deployedId, deployedName, resourceId, prototype):
    ignoredProps = getUnsupportedTypeAttrs(prototype.wasType, prototype.getExposedProperties(True).keys())
    ignoredProps.append("name")
    inspectDeployedProperties(deployedId, deployedName, resourceId, prototype, ignoredProps)

    for nodeId in wsadminToList(AdminConfig.getid("/Node:/")):
        nodeName = AdminConfig.showAttribute(nodeId, "name")
        if deployedName in [AdminConfig.showAttribute(raId, "name") for raId in wsadminToList(AdminConfig.getid("/Node:%s/J2CResourceAdapter:/" % nodeName))]:
            inspectedProperty(deployedId, "nodeName", nodeName)

    inspectNestedJ2EEResourceProperties(deployedId, resourceId, "propertySet", "customProperties")

