package com.xebialabs.deployit.plugin.was.controltask;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import com.google.common.collect.Maps;

import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Delegate;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagedDeployed;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;

import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Strings.isNullOrEmpty;
import static com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder.resolveExpression;

@SuppressWarnings("serial")
public class PythonScriptControlTaskDelegate implements Serializable {

    @Delegate(name = "pythonControlTask")
    public List<Step> invokeDispatcher(ConfigurationItem ci, final String methodName, Map<String, String> arguments, Parameters parameters) {
        String script = arguments.get("script");

        checkArgument(!isNullOrEmpty(script), "Argument 'script' is required.");

        ConfigurationItem container = ci;
        if (ci instanceof Container) {
            container = ci;
        } else if (ci instanceof PythonManagedDeployed) {
            container = ((PythonManagedDeployed)ci).getContainer();
        }

        String itemVarContextName = (ci instanceof Container) ? "container":"deployed";
        Map<String, Object> thisVarContext = Maps.newLinkedHashMap();
        thisVarContext.put(itemVarContextName, ci);
        String scriptName = resolveExpression(script, thisVarContext);
        thisVarContext.put("arguments", arguments);
        thisVarContext.put("parameters", parameters);

        if (container == null) {
            throw new IllegalArgumentException(String.format("Control task '%s' with python script '%s' can only be run against a ci of type python.PythonManagedDeployed or container that is a python.PythonManagingContainer or implements python.PythonManagedContaner. CI '%s' does not satisfies those conditions.", methodName, scriptName, container));
        }

        PythonManagingContainer pythonManagingContainer = null;
        if (container instanceof PythonManagedContainer) {
            pythonManagingContainer = ((PythonManagedContainer)container).getManagingContainer();
        } else if (container instanceof  PythonManagingContainer) {
            pythonManagingContainer = (PythonManagingContainer) container;
        }

        if (pythonManagingContainer == null) {
            throw new IllegalArgumentException(String.format("Control task '%s' with python script '%s' can only be run against a container that is a python.PythonManagingContainer or implements python.PythonManagedContaner. Container '%s' does not.", methodName, scriptName, container));
        }

        String desc = "Executing " + methodName + " on " + ci;
        return Collections.<Step>singletonList(new PythonDeploymentStep(1, pythonManagingContainer, scriptName, thisVarContext, desc));
    }

}
