#
################################################################################################################
# General utility functions
################################################################################################################
def getParentOfType(childId, childType, parentType):
    for c in findAllContainers(container):
        for parentId in wsadminToList(AdminConfig.getid("%s/%s:/" % (c.containmentPath, parentType))):
            results = AdminConfig.list(childType, parentId)
            if childId in wsadminToList(results):
                return parentId
################################################################################################################
# J2C utility functions
################################################################################################################
def getJ2CResourceAdapter(deployed):
    name = deployed.name
    if hasattr(deployed, 'provider'):
        name = deployed.provider
    providerContainmentPath = '%s/J2CResourceAdapter:%s' % (deployed.container.containmentPath, name)
    providerId = validateNotEmpty(AdminConfig.getid(providerContainmentPath), "Cannot find WebSphere J2C Resource Adapter '%s' on container '%s'" % (name, deployed.container.name));
    return providerId

def discoverAndInspectJ2CObjectProperties(canHandleContainerPropertyTypeCallback=None, containerPropertyInspectCallback=None, listObjectsInContainerCallback=None):
    if containerPropertyInspectCallback is None:
        containerPropertyInspectCallback = inspectDeployedProperties
    for c in findAllContainers(container):
        inspectAdminConfigPropertiesCallback(c, prototype, canHandleContainerPropertyTypeCallback, containerPropertyInspectCallback, listObjectsInContainerCallback)

def destroyJ2CObject(deployed):
    for id in  wsadminToList(AdminConfig.list(deployed.wasType, getJ2CResourceAdapter(deployed))):
        if AdminConfig.showAttribute(id, "name") == deployed.name:
            print "Destroying %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name)
            AdminConfig.remove(id)
            return
    printErrorAndExit("Cannot find %s '%s' in container '%s'" % (deployed.wasType, deployed.name, deployed.container.name))

def listJ2CResourceAdaptersInContainerCallback(container, prototype):
    providerContainmentPath = '%s/J2CResourceAdapter:/' % container.containmentPath
    return validateNotEmpty(wsadminToList(AdminConfig.getid(providerContainmentPath)), "Cannot locate provider '%s'" % (providerContainmentPath))

def listJ2CObjectsInContainerCallback(container, prototype):
    providerIds = listJ2CResourceAdaptersInContainerCallback(container, prototype)

    ignoredProviderNames = prototype.standardProvidersToIgnore.split(",")
    if prototype.additionalProvidersToIgnore:
        ignoredProviderNames.extend(prototype.additionalProvidersToIgnore.split(","))

    discoveredJ2CObjects = []
    for providerId in providerIds:
        providerName = AdminConfig.showAttribute(providerId, "name")
        if providerName not in ignoredProviderNames:
            discoveredJ2CObjects.extend(wsadminToList(AdminConfig.list(prototype.wasType, providerId)))

    return discoveredJ2CObjects
