#
def discoverAndInspectSibTopic(c):
    cid = AdminConfig.getid(c.containmentPath)
    topics = AdminTask.listSIBJMSTopics(cid)
    if topics == "":
        return
    for topic in topics.splitlines():
        deployedName = AdminConfig.showAttribute(topic, 'name')
        deployedId = c.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectSibTopic(deployedId, deployedName, topic)
        inspectedItem(deployedId)


def inspectSibTopic(deployedId, depoyedName, topicId):
    inspectedProperty(deployedId, 'jndiName', AdminConfig.showAttribute(topicId, 'jndiName'))
    properties = AdminConfig.showAttribute(topicId, 'properties')[1:-1].split(' ')
    for p in properties:
        pName = AdminConfig.showAttribute(p, 'name')
        pName = pName[0:1].lower() + pName[1:]
        pValue = AdminConfig.showAttribute(p, 'value')
        if pValue == None:
            continue
        if pName == 'topicSpace':
            pValue = '%s/%s' % (container.id, pValue)
        inspectedProperty(deployedId, pName, pValue)

for c in findAllContainers(container):
    discoverAndInspectSibTopic(c)
