import time

# as per 7.0, can also use AdminClusterManagement.startSingleCluster() - see
# http://publib.boulder.ibm.com/infocenter/wasinfo/fep/index.jsp?topic=%2Fcom.ibm.websphere.nd.multiplatform.doc%2Finfo%2Fae%2Fae%2Frxml_7libadmincluster.html
cluster = AdminControl.completeObjectName('type=Cluster,name=%s,*' % (container.name))

if cluster == "":
  print "Unable to find cluster '%s'" % (container.name)
  raise Exception("Unable to find cluster '%s'" % (container.name))

state = AdminControl.getAttribute(cluster, 'state')
if state == "websphere.cluster.running":
    print "WARN: Cluster '%s' already running. Nothing to do." % (container.name)
else:
    print "Starting cluster '%s'" % (container.name)
    startType = 'start'
    if container.enableRippleStart:
        startType = 'rippleStart'
    AdminControl.invoke(cluster, startType)
    numAttempts = 1
    while True:
        if numAttempts == 10:
            print "ERROR: Unable to start cluster after %s attempts" % (numAttempts)
            sys.exit(1)
        state = AdminControl.getAttribute(cluster, 'state')
        if state == "websphere.cluster.running":
            break
        print "\nAttempt %s: Waiting for %s cluster to start." % (numAttempts, container.name)
        time.sleep(container.checkStartedInterval)
        numAttempts = numAttempts + 1
    print "Started cluster '%s'" % (container.name)
