mailPropertiesList = ['mailStoreHost', 'mailStoreUser', 'mailStorePassword', 'mailFrom', 'mailTransportHost', 'mailTransportUser', 'mailTransportPassword']

def inspectNestedMailSessionsInContainer(deployedId, mailSession, nestedProperty, property):
    nestedPropId = AdminConfig.showAttribute(mailSession, nestedProperty)
    if nestedPropId:
        inspectedProperty(deployedId, nestedProperty, AdminConfig.showAttribute(nestedPropId, property))

def discoverAndInspectMailSessionsInContainer(container):
    containerId = AdminConfig.getid(container.containmentPath)
    mailSessions = wsadminToList(AdminConfig.list('MailSession', containerId))
    for mailSession in mailSessions:
        deployedName = AdminConfig.showAttribute(mailSession, 'name')
        deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectDeployedProperties(deployedId, deployedName, mailSession, prototype)
        inspectNestedMailSessionsInContainer(deployedId, mailSession, 'mailStoreProtocol', 'protocol')
        inspectNestedMailSessionsInContainer(deployedId, mailSession, 'mailTransportProtocol', 'protocol')
        inspectNestedMailSessionsInContainer(deployedId, mailSession, 'provider', 'name')
        for property in mailPropertiesList:
            inspectedProperty(deployedId, property, AdminConfig.showAttribute(mailSession, property))
        inspectNestedJ2EEResourceProperties(deployedId, mailSession, "propertySet", "customProperties")
        inspectedItem(deployedId)

for c in findAllContainers(container):
    discoverAndInspectMailSessionsInContainer(c)
