
def createConnectionFactory(args, provider, deployed):
    jmsProviderContainmentPath = '%s/JMSProvider:%s' % (deployed.container.containmentPath, provider)
    jmsProviderId = validateNotEmpty(AdminConfig.getid(jmsProviderContainmentPath), "Cannot locate WebSphere JMS Provider '%s' in container '%s'" % (provider, deployed.container.name))
    print "Creating '%s' for JMS provider '%s' with args '%s' in container '%s'" % (deployed.wasType, jmsProviderId, args, deployed.container.name)
    connectionFactoryId = AdminConfig.create(deployed.wasType, jmsProviderId, args)
    configureConnectionFactoryNestedObjects(connectionFactoryId, deployed)
    if hasattr(deployed, 'customProperties'):
        createJ2EEResourceProperties(jmsProviderId, deployed)

def discoverConnectionFactoryNestedObjects(deployedId, jmsId, nestedProperty, nestedAttribute):
    attributeId = AdminConfig.showAttribute(jmsId, nestedAttribute)
    attributes = AdminConfig.show(attributeId)
    attrMap = wsadminToDict(attributes)
    for key in attrMap.keys():
        inspectedProperty(deployedId, "%s%s"  % (nestedProperty, key), attrMap[key])

def discoverConnectionFactoryMappingObjects(deployedId, jmsId, mappingObject):
    attributeId = AdminConfig.showAttribute(jmsId, mappingObject)
    attributes = wsadminToDict(AdminConfig.show(attributeId))
    for key in attributes.keys():
        if attributes[key] and attributes[key] != '[]':
            if key != "authDataAlias":
                inspectedProperty(deployedId, key, attributes[key])
            else:
                inspectedProperty(deployedId, 'containerAuthDataAlias', attributes[key])

def inspectWmqQueueConnectionFactories(deployedId, jmsName, jmsId, container, prototype):
    ignoredProps = ['name']
    if getVersion(container) == 'WAS_61': ignoredProps.append('providerVersion')
    inspectDeployedProperties(deployedId, jmsName, jmsId, prototype, ignoredProps)
    discoverConnectionFactoryNestedObjects(deployedId, jmsId, 'ConnectionPool_', 'connectionPool')
    discoverConnectionFactoryNestedObjects(deployedId, jmsId, 'SessionPool_', 'sessionPool')
    discoverConnectionFactoryMappingObjects(deployedId, jmsId, 'mapping')
    inspectNestedJ2EEResourceProperties(deployedId, jmsId, "propertySet", "customProperties")

def modifyConnectionFactory(args, provider, deployed):
    containmentPath = '%s/JMSProvider:%s/%s:%s' % (deployed.container.containmentPath, provider, deployed.wasType, deployed.name)
    providerId = validateNotEmpty(AdminConfig.getid(containmentPath), "Cannot locate containment path '%s'" % (containmentPath))
    print "Modifying '%s' for JMS provider '%s' with args '%s' in container '%s'" % (deployed.wasType, providerId, args, deployed.container.name)
    AdminConfig.modify(providerId, args)
    configureConnectionFactoryNestedObjects(providerId, deployed)

def createOrModifyMappingModule(providerId, deployed):
    mappingArgs = [
        ['authDataAlias', mapToEmptyList(deployed.containerAuthDataAlias)],
        ['mappingConfigAlias', mapToEmptyList(deployed.mappingConfigAlias)]
    ]
    mapping = AdminConfig.showAttribute(providerId, 'mapping')
    if mapping:
        print "Modifying MappingModule with the args '%s'" % (mappingArgs)
        AdminConfig.modify(mapping, mappingArgs)
    else:
        print "Creating MappingModule with the args '%s'" % (mappingArgs)
        AdminConfig.create('MappingModule', providerId, mappingArgs)

def configureConnectionFactoryNestedObjects(providerId, deployed):
    createOrModifyMappingModule(providerId, deployed)
    if hasattr(deployed, 'ConnectionPool'):
        poolArgs = toAdminConfigArgs(deployed.ConnectionPool.getExposedProperties())
        configureConnectionPool(providerId, poolArgs, 'connectionPool')
    if hasattr(deployed, 'SessionPool'):
        poolArgs = toAdminConfigArgs(deployed.SessionPool.getExposedProperties())
        configureConnectionPool(providerId, poolArgs, 'sessionPool')
    removeJ2EEResourceProperties(providerId)
    if hasattr(deployed, 'customProperties'):
        createJ2EEResourceProperties(providerId, deployed)

def genericConnectionFactoryArgs(deployed, exposedProperties):
    exposedProperties['type'] = deployed.genericJmsDestinationType
    return toAdminConfigArgs(exposedProperties)

def jmsConnectionFactoryArgs(deployed):
    exposedProperties = deployed.getExposedProperties(True)
    if getVersion(deployed.container) == 'WAS_61':
        if 'providerVersion' in exposedProperties.keys():
            print "Ignoring property 'providerVersion' which is not supported on WAS 6.1"
            del exposedProperties['providerVersion']
        if deployed.transportType == 'BINDINGS_THEN_CLIENT':
            print "BINDINGS_THEN_CLIENT default mappend to BINDINGS on WAS 6.1"
            exposedProperties['transportType'] = 'BINDINGS'
    for p in ['queueManager', 'host', 'channel', 'clientID', 'authDataAlias']:
        if not exposedProperties[p]:
            exposedProperties[p] = ''
    return toAdminConfigArgs(exposedProperties)
