#
def inspectWorkManagerServiceNamesProperties(deployedId,managerId,ServiceProperty,ServiceAttribute):
    attributes = AdminConfig.showAttribute(managerId,"%s" % (ServiceAttribute))
    serviceNamesDict = {"applicationProfilingService":"AppProfileService","workArea":"UserWorkArea","internationalization":"com.ibm.ws.i18n","security":"security"}
    for key in serviceNamesDict.keys() :
        serviceNamePropertyValue="true"
        serviceNamesValue = serviceNamesDict[key]
        if(attributes.find(serviceNamesValue)<0) :
            serviceNamePropertyValue = "false"
        inspectedProperty(deployedId,"%s%s" % (ServiceProperty,key),serviceNamePropertyValue)

def inspectWorkManagerProperties(deployedId, managerName, managerId):
    print "Inspecting %s %s" % (prototype.type, managerName)
    exposedProperties = prototype.getExposedPropertyNames()
    for p in exposedProperties:
        if p != "name":
            propertyValue=AdminConfig.showAttribute(managerId, p)
            if p == "workReqQFullAction":
                if propertyValue == '0':
                    propertyValue = 'Block'
                else:
                    propertyValue = 'Fail'
            inspectedProperty(deployedId, p,propertyValue)

def discoverAndInspectWorkManagerProperties(container):
    workManagersList = wsadminToList(AdminConfig.list('WorkManagerInfo',AdminConfig.getid(container.containmentPath)))
    for managerId in workManagersList:
        deployedName = AdminConfig.showAttribute(managerId, 'name')
        deployedId = container.id + '/' + deployedName
        discovered(deployedId, prototype.type)
        inspectWorkManagerServiceNamesProperties(deployedId,managerId,'ServiceNames_',"serviceNames")
        inspectWorkManagerProperties(deployedId, deployedName, managerId)
        inspectedItem(deployedId)


for c in findAllContainers(container):
    discoverAndInspectWorkManagerProperties(c)