import types
import sys
import time

def printErrorAndExit(msg):
    print >> sys.stderr, msg
    sys.exit(1)

def printError(msg):
    print >> sys.stderr, msg

def toAdminConfigArgs(properties):
    args = []
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                args.append([propName, str(propValue.name)])
            else:
                args.append([propName, str(propValue)])
    return args

def toAdminTaskArgs(properties):
    args = []
    for propName, propValue in properties.items():
        if propValue != None:
            if isinstance(propValue, DictionaryObject):
                args.extend(["-" + propName, str(propValue.name)])
            else:
                args.extend(["-" + propName, str(propValue)])
    return args

def validateNotEmpty(val, error):
    if val is None or val == "":
        printErrorAndExit(error)
    return val

def exitWithMessageIfEmpty(val, message, exitCode = 0):
    if val is None or val == "":
        if message:
            print message
        sys.exit(exitCode)
    return val

# Functions invoked by the PythonScriptStep

def saveConfiguration():
    if AdminConfig.hasChanges():
        print "Saving configuration"
        AdminConfig.save()

def connectFromDaemon():
    pass

def connectFromStandAloneScript():
    pass

def disconnectFromDaemon():
    pass

def disconnectFromStandAloneScript():
    saveConfiguration()

def runScriptFromDaemon(scriptPath):
    #Execute the script in its own global scope, so that functions defined in the script can find each other.
    execfile(scriptPath, globals().copy())
    saveConfiguration()

def disconnectFromDaemonForError():
    if AdminConfig.hasChanges():
        print "Discarding unsaved changes"
        AdminConfig.reset()

def findAllContainers(cell, onlyWasAppContainer=False):
    containers = []
    if cell.type == "was.UnmanagedServer":
        containers.append(cell)
    elif cell.type == "was.DeploymentManager":
        if (not onlyWasAppContainer):
            containers.append(cell)
        for cluster in cell.clusters:
            containers.append(cluster)
        for node in cell.nodeAgents:
            if (not onlyWasAppContainer):
                containers.append(node)
            for server in node.servers:
                containers.append(server)
    return containers

#*******************************************************************************************************
# convert a string as returned by AdminConfig.show[Attribute] to a Jython list
#*******************************************************************************************************
def wsadminToList(inStr):
  outList=[]
  if (len(inStr)>0 and inStr[0]=='[' and inStr[-1]==']'):
    inStr = inStr[1:-1]
    tmpList = inStr.split(" ")
  else:
    tmpList = inStr.split("\n")	 #splits for Windows or Linux
  for item in tmpList:
    item = item.rstrip();		 #removes any Windows "\r"
    if (len(item)>0):
      outList.append(item)
  return outList

#
# Transforms AdminConfig.show(xxx) to dictionary
# Example input: '[name webserver1]\n[nodeName was-61-appserver-node]'
# Will result in: {'name': 'webserver1', 'nodeName': 'was-61-appserver-node'}
#
def wsadminToDict(inStr):
    map = {}
    for l in inStr.splitlines():
        pieces = l[1:-1].split(" ")
        map[pieces[0]] = pieces[1]

    return map
#endDef

def mapToEmptyList(value, booleanValue = True):
    """ map value to empty list if it's empty or if booleanValue is false """
    if not value:
        return []
    if not booleanValue:
        return []
    return value

def noneToEmpty(value):
    """ map value to an empty string if it is None """
    if value is None:
        return ""
    else:
        return value

######################################################################
#
#Returns the WAS version
######################################################################
def getVersion(wasContainer):
    if hasattr(wasContainer,'version'):
       return wasContainer.version
    if hasattr(wasContainer, 'cell'):
       return wasContainer.cell.version
    if hasattr(wasContainer, 'node'):
       return wasContainer.node.cell.version


#######################################################################
#
# discovers AdminConfig object properties
#######################################################################

def inspectAdminConfigPropertiesCallback(container,prototype, canHandleAdminConfigPropertyTypeCallback, adminConfigPropertyTypeInspectCallback):
  print "Retrieving list of %s objects in container %s" % (prototype.wasType, container.name)
  AdminConfigPropertiesList = wsadminToList(AdminConfig.list(prototype.wasType,AdminConfig.getid(container.containmentPath)))
  for p in AdminConfigPropertiesList:
    if canHandleAdminConfigPropertyTypeCallback is None or canHandleAdminConfigPropertyTypeCallback(p):
      name = AdminConfig.showAttribute(p, 'name')
      print "Discovered %s %s in container %s" % (prototype.type, name, container.name)
      deployedId = container.id + '/' + name
      discovered(deployedId, prototype.type)
      adminConfigPropertyTypeInspectCallback(deployedId, name, p, prototype)
      inspectedItem(deployedId)

#################################################################
#
#inspects properties of the Deployed
#################################################################

def inspectDeployedProperties(id, name, propertyId, prototype, ignoredProperties = ['name']):
  print "Inspecting %s %s" % (prototype.type, name)
  for p in prototype.getExposedPropertyNames():
    if p not in ignoredProperties:
      val = AdminConfig.showAttribute(propertyId, p)
      if val == '[]': val = []
      inspectedProperty(id, p, val)

#################################################################
#
#synchronize all the Nodes
#################################################################

def syncNodes(cell):
    for node in cell.nodeAgents:
        nodeName = node.name
        print "Synchronizing '%s'" % (nodeName)
        sync = AdminControl.completeObjectName("type=NodeSync,node=%s,*" % (nodeName))
        if sync == '':
            raise "Node '%s' does not exist or is not running" % (nodeName)
        AdminControl.invoke(sync, 'sync');
        print "Completed synchronization of '%s'" % (nodeName)

def isServerRunning(serverName) :
    return AdminControl.completeObjectName("WebSphere:type=Server,name=%s,*" % (serverName)) != ""

def isClusterRunning(clusterName) :
    cluster = AdminControl.completeObjectName("WebSphere:type=Cluster,name=%s,*" % (clusterName))
    if cluster != "":
        state = AdminControl.getAttribute(cluster, 'state')
        return state != "websphere.cluster.stopped"
    return False

###################################################################
#
#Creating,deleting and Inspection of custom properties...
###################################################################

def createCustomProps(parentId, customProp, deployed):
    if hasattr(deployed, 'customProperties'):
        for name, value in deployed.customProperties.items():
            print "Creating Custom Property '%s' for '%s'" % (name, parentId)
            AdminConfig.create(customProp, parentId, [['name', name], ['value', value]])

def removeCustomProps(parentId, customProp):
    customProperties = wsadminToList(AdminConfig.showAttribute(parentId, customProp))
    for customPropId in customProperties:
        print "Removing Custom Property %s" %(customPropId)
        AdminConfig.remove(customPropId)

def inspectCustomProperties(deployedId, nestedPropId, deployitProperty):
    customProperties = {}
    if nestedPropId:
        for propsetItem in nestedPropId:
            customProperties[AdminConfig.showAttribute(propsetItem, "name")] = AdminConfig.showAttribute(propsetItem, "value")
        if len(customProperties) > 0:
            inspectedProperty(deployedId, deployitProperty, customProperties)

#############################################################################
#
#Creating, Deleting, Inspection of J2EE Resource Properties
#############################################################################
def inspectNestedJ2EEResourceProperties(deployedId, resourceId, nestedProperty, deployitProperty):
    nestedResourcePropId = AdminConfig.showAttribute(resourceId, nestedProperty)
    if nestedResourcePropId:
        nestedPropId = wsadminToList(AdminConfig.list("J2EEResourceProperty", nestedResourcePropId))
        inspectCustomProperties(deployedId, nestedPropId, deployitProperty)

def createJ2EEResourceProperties(resourceId, deployed):
    nestedResourcePropId = AdminConfig.showAttribute(resourceId, 'propertySet')
    if nestedResourcePropId is None:
        print "Creating J2EE Resource Property set for '%s'" % (resourceId)
        nestedResourcePropId = AdminConfig.create('J2EEResourcePropertySet', resourceId, [])
    createCustomProps(nestedResourcePropId, 'J2EEResourceProperty', deployed)

def removeJ2EEResourceProperties(resourceId):
    nestedResourcePropertySetId = AdminConfig.showAttribute(resourceId, 'propertySet')
    if nestedResourcePropertySetId:
        removeCustomProps(nestedResourcePropertySetId, 'resourceProperties')

#######################################################################
# Create Connection or Session Pool on parentId
#######################################################################
def configureConnectionPool(parentId, poolArgs, attributeName):
    print "Creating '%s' with '%s'" % (attributeName, poolArgs)
    AdminConfig.create('ConnectionPool', parentId, poolArgs, attributeName)
