/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.Cluster;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.ManagedServer;
import com.xebialabs.deployit.plugin.was.container.ManagedWebServer;
import com.xebialabs.deployit.plugin.was.container.Node;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryWasTopologyStep
extends PythonInspectionStep {
    private Cell cell;
    private boolean skipDiscovery;

    public DiscoveryWasTopologyStep(BaseCell cell, boolean skipDiscovery) {
        super((ConfigurationItem)cell, (PythonManagingContainer)cell, cell.getInspectScript(), DiscoveryWasTopologyStep.createPythonVars(cell), "Inspect " + cell);
        this.cell = cell;
        this.skipDiscovery = skipDiscovery;
    }

    private static Map<String, Object> createPythonVars(Cell cell) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", cell);
        return pythonVars;
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        if (this.cell instanceof DeploymentManager) {
            DeploymentManager dmgr = (DeploymentManager)this.cell;
            if (this.skipDiscovery) {
                for (Node node : dmgr.getNodes()) {
                    ctx.getInspectionContext().discovered((ConfigurationItem)node);
                    ctx.getInspectionContext().inspected((ConfigurationItem)node);
                    for (ManagedServer managedServer : ((NodeAgent)node).getServers()) {
                        ctx.getInspectionContext().discovered((ConfigurationItem)managedServer);
                        ctx.getInspectionContext().inspected((ConfigurationItem)managedServer);
                    }
                    for (ManagedWebServer managedWebServer : ((NodeAgent)node).getWebServers()) {
                        ctx.getInspectionContext().discovered((ConfigurationItem)managedWebServer);
                        ctx.getInspectionContext().inspected((ConfigurationItem)managedWebServer);
                    }
                }
                for (Cluster cluster : dmgr.getClusters()) {
                    ctx.getInspectionContext().discovered((ConfigurationItem)cluster);
                    ctx.getInspectionContext().inspected((ConfigurationItem)cluster);
                }
                return StepExitCode.SUCCESS;
            }
            dmgr.getNodes().clear();
            dmgr.getClusters().clear();
        }
        return super.execute(ctx);
    }
}

