########################################################################################################################
#
# Function to discover and inspect jms objects (queues, connections factories) in all scopes.
#
# canHandleJmsTypeCallback : if the caller can handle the specific jms object.
#     jmsObjectId - WAS id
#
# jmsInspectCallback : the inspection function that should be used. Default is the inspectJmsObject function in this lib.
#     deployedId - id of discovered ci.
#     jmsName - name of the jms object
#     jmsId - WAS id for the jms object
#     container - Deployit container on which the jms object resides.
#
########################################################################################################################
def discoverAndInspectJmsObjects(canHandleJmsTypeCallback=None, jmsInspectCallback=None):
    if jmsInspectCallback is None:
        jmsInspectCallback = inspectJmsObject
    for c in findAllContainers(container):
        discoverAndInspectJmsObjectsInContainer(c, canHandleJmsTypeCallback, jmsInspectCallback)


def discoverAndInspectJmsObjectsInContainer(container, canHandleJmsTypeCallback, jmsInspectCallback):
    print "Retrieving list of %s objects in container %s" % (prototype.wasType, container.name)
    jmsObjects = AdminConfig.getid('%s/JMSProvider:/%s:/' % (container.containmentPath, prototype.wasType)).splitlines()
    for o in jmsObjects:
        if canHandleJmsTypeCallback is None or canHandleJmsTypeCallback(o):
            name = AdminConfig.showAttribute(o, 'name')
            print "Discovered %s %s in container %s" % (prototype.type, name, container.name)
            deployedId = container.id + '/' + name
            discovered(deployedId, prototype.type)
            jmsInspectCallback(deployedId, name, o, container)
            inspectedItem(deployedId)



def inspectJmsObject(deployedId, jmsName, jmsId, container):
    print "Inspecting %s %s" % (prototype.wasType, jmsName)
    for p in prototype.getExposedPropertyNames():
        if p != "name":
            inspectedProperty(deployedId, p, AdminConfig.showAttribute(jmsId, p))

