def additionalInspection(deployedId,appName, deploymentObjectId, container):
    inspectedProperty(deployedId, "contextRoot",getContextRoot(appName))
    inspectedProperty(deployedId, "virtualHost",getVirtualHostIdForApp(appName))
    webServers = resolveWebServers(appName)
    if len(webServers) > 0:
        inspectedProperty(deployedId, "webServers", webServers)

def canHandleOnlyWar(type):
    return type == "war"

for c in findAllContainers(container, onlyWasAppContainer=True):
    discoverAndInspectAppModules(c, canHandleOnlyWar, additionalInspection)
