#

installArgs = ['-appname', deployed.name]

# if this is not a WAR deployment, the contextroot property will not be present on the deployed
if hasattr(deployed, 'contextRoot'):
    installArgs.extend(['-contextroot', deployed.contextRoot])

targets = "WebSphere:cell=%s,%s=%s" % (deployed.container.cellName, deployed.container.wasTargetType, deployed.container.name)

# if this is an EJB deployment, the webServers property will not be present on the deployed
if hasattr(deployed, 'webServers'):
    for ws in deployed.webServers:
        targets += "+WebSphere:cell=%s,node=%s,server=%s" %(ws.node.cellName,ws.node.nodeName,ws.name)

servermappings = []
servermappings.append(['.*', '.*', targets])
installArgs.extend(['-MapModulesToServers', servermappings])

vhostmappings = []
if hasattr(deployed, 'virtualHost') and deployed.virtualHost != None:
    vhostmappings.append(['.*', '.*', deployed.virtualHost.name])
else:
    vhostmappings.append(['.*', '.*', 'default_host'])
installArgs.extend(['-MapWebModToVH', vhostmappings])

if len(deployed.sharedLibraries) > 0:
    sharedLibraryMappings = []
    sharedLibNames = ''
    for l in deployed.sharedLibraries:
        sharedLibNames += '+' + l.name
    sharedLibraryMappings.append(['.*', '.*', sharedLibNames])
    installArgs.extend(['-MapSharedLibForMod', sharedLibraryMappings])
    
if hasattr(deployed, 'roleMappings'):
    roleMappings = []
    for role,group in deployed.roleMappings.items():
        if group == 'Everyone':
            roleMappings.append([role, 'Yes', 'No', '', ''])
        else:
            roleMappings.append([role, 'No', 'No', '', group])
    if len(roleMappings) > 0:
        installArgs.extend(['-MapRolesToUsers', roleMappings])

# if this is an EJB deployment, the preCompileJsps property will not be present on the deployed
if hasattr(deployed, 'preCompileJsps') and deployed.preCompileJsps:
    installArgs.extend(['-preCompileJSPs','-JSPCompileOptions', [['.*', '.*', 'jspcp', 'Yes', 15, 'No']]])

installArgs.append('-usedefaultbindings')

print "Deploying application", deployed.name, "with args: %s" % (installArgs)
AdminApp.install(deployed.file, installArgs)

deployment = AdminConfig.getid('/Deployment:%s' % (deployed.name))
deployedObject = AdminConfig.showAttribute(deployment, 'deployedObject')

# if this is not an EAR deployment, the startingWeight property will not be present on the deployed
if hasattr(deployed, 'startingWeight'):
    AdminConfig.modify(deployedObject, [['startingWeight', str(deployed.startingWeight)]])
