#

import sys
import time

def startApplicationOnServer(appName, cellName, serverName, serverNodeName):
    appMgrName = "cell=%s,node=%s,type=ApplicationManager,process=%s,*" % (cellName, serverNodeName, serverName)
    appMgr = AdminControl.queryNames(appMgrName)
    if appMgr == '':
        print "Cannot (completely) start", appName,"because the server", serverName, "has not been started."
        return 1
    else:
        print "Starting application", appName, "on", serverName
        AdminControl.invoke(appMgr, 'startApplication', '["' + appName + '"]')
        print "Done."
    return 0

# Wait for application to be installed
while True :
    if AdminApp.isAppReady(deployed.name) == 'true':
        break;
    print "\nWaiting for", deployed.name, "deployment to finish."
    time.sleep(10)

result = 0
if (deployed.container.wasTargetType == "cluster"):
    clusterId = AdminConfig.getid(deployed.container.containmentPath)
    membersProperty = AdminConfig.showAttribute(clusterId, 'members')
    members = membersProperty[1:-1].split()
    for member in members:
        serverName = AdminConfig.showAttribute(member, 'memberName')
        serverNodeName = AdminConfig.showAttribute(member, 'nodeName')
        if isApplicationRunningOnServer(deployed.name, serverName, serverNodeName):
            print "Application", deployed.name, "on", serverName, "already started."
        else:
            try:
                result = startApplicationOnServer(deployed.name, deployed.container.cellName, serverName, serverNodeName)
            except:
                if isApplicationRunningOnServer(deployed.name, server.name, server.nodeName):
                    print "An exception occurred while starting Application", deployed.name, "on", server.name, ", but it appears to have started anyway."
                else:
                    raise
else:
    if isApplicationRunningOnServer(deployed.name, deployed.container.name, deployed.container.nodeName):
        print "Application", deployed.name, "on", deployed.container.name, "already started."
    else:
        try:
            result = startApplicationOnServer(deployed.name, deployed.container.cellName, deployed.container.name, deployed.container.nodeName)
        except:
            if isApplicationRunningOnServer(deployed.name, server.name, server.nodeName):
                print "An exception occurred while starting Application", deployed.name, "on", server.name, ", but it appears to have started anyway."
            else:
                raise

sys.exit(result)
