/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;

public class CheckWasInstallationStep
implements Step {
    private Cell cell;
    private boolean validInstallation;

    public CheckWasInstallationStep(Cell cell) {
        this.cell = cell;
    }

    public int getOrder() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StepExitCode execute(ExecutionContext executionContext) throws Exception {
        OverthereConnection overthereConnection = this.cell.getHost().getConnection();
        try {
            this.validInstallation = true;
            this.checkDirectoryExistence(executionContext, overthereConnection, this.cell.getWasHome());
            this.checkDirectoryExistence(executionContext, overthereConnection, this.cell.getConfigDirPath());
            this.checkFileExistenceAndExecutability(executionContext, overthereConnection, this.cell.getVersionInfoPath());
            this.checkFileExistenceAndExecutability(executionContext, overthereConnection, this.cell.getWsadminPath());
            StepExitCode stepExitCode = this.validInstallation ? StepExitCode.SUCCESS : StepExitCode.FAIL;
            return stepExitCode;
        }
        finally {
            overthereConnection.close();
        }
    }

    protected void checkDirectoryExistence(ExecutionContext executionContext, OverthereConnection overthereConnection, String string) {
        executionContext.logOutput("Checking whether directory " + string + " exists on " + this.cell.getHost());
        if (!overthereConnection.getFile(string).exists()) {
            executionContext.logError("Directory " + string + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        }
    }

    private void checkFileExistenceAndExecutability(ExecutionContext executionContext, OverthereConnection overthereConnection, String string) {
        executionContext.logOutput("Checking whether file " + string + " exists on " + this.cell.getHost() + " exists" + (overthereConnection.getHostOperatingSystem() == OperatingSystemFamily.UNIX ? " and is executable" : ""));
        if (!overthereConnection.getFile(string).exists()) {
            executionContext.logError("File " + string + " does not exist on " + this.cell.getHost());
            this.validInstallation = false;
        } else if (overthereConnection.getHostOperatingSystem() == OperatingSystemFamily.UNIX && !overthereConnection.getFile(string).canExecute()) {
            executionContext.logError("File " + string + " on " + this.cell.getHost() + " is not executable");
            this.validInstallation = false;
        }
    }

    public String getDescription() {
        return "Checking whether " + this.cell + " is a valid WebSphere Application Server installation";
    }
}

