/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.python.PythonDeploymentStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.NodeAgent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class NodeSynchronizer {
    @Contributor
    public void syncNodes(Deltas deltas, DeploymentPlanningContext deploymentPlanningContext) {
        Multimap<Integer, NodeAgent> multimap = NodeSynchronizer.getNodesToSync(deploymentPlanningContext);
        Iterator iterator = multimap.keySet().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (NodeAgent nodeAgent : multimap.get((Object)n)) {
                HashMap hashMap = Maps.newHashMap();
                hashMap.put("nodeName", nodeAgent.getNodeName());
                deploymentPlanningContext.addStep((Step)new PythonDeploymentStep(n, (PythonManagingContainer)nodeAgent.getCell(), nodeAgent.getSynchronizeScript(), (Map)hashMap, "Synchronize " + nodeAgent.getName()));
            }
        }
        multimap.clear();
    }

    private static Multimap<Integer, NodeAgent> getNodesToSync(DeploymentPlanningContext deploymentPlanningContext) {
        Multimap multimap = (Multimap)deploymentPlanningContext.getAttribute("was.nodesToSync");
        if (multimap == null) {
            multimap = HashMultimap.create();
            deploymentPlanningContext.setAttribute("was.nodesToSync", (Object)multimap);
        }
        return multimap;
    }

    public static void addNodeToSync(DeploymentPlanningContext deploymentPlanningContext, int n, NodeAgent nodeAgent) {
        NodeSynchronizer.getNodesToSync(deploymentPlanningContext).put((Object)n, (Object)nodeAgent);
    }
}

