package com.xebialabs.deployit.plugin.was.step;

import static com.xebialabs.overthere.OperatingSystemFamily.UNIX;

import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.overthere.OverthereConnection;

@SuppressWarnings("serial")
public class CheckWasInstallationStep implements InspectionStep {

	private Cell cell;
	
	private boolean validInstallation;

	public CheckWasInstallationStep(Cell cell) {
		this.cell = cell;
	}

	@Override
	public Step.Result execute(InspectionExecutionContext ctx) throws Exception {
		OverthereConnection c = cell.getHost().getConnection();
		try {
			validInstallation = true;
			checkDirectoryExistence(ctx, c, cell.getWasHome());
			checkDirectoryExistence(ctx, c, cell.getConfigDirPath());
			checkFileExistenceAndExecutability(ctx, c, cell.getVersionInfoPath());
			checkFileExistenceAndExecutability(ctx, c, cell.getWsadminPath());

			return validInstallation ? Result.Success : Result.Fail;
		} finally {
			c.close();
		}
	}

	protected void checkDirectoryExistence(InspectionExecutionContext ctx, OverthereConnection c, String dirPath) {
		ctx.logOutput("Checking whether directory " + dirPath + " exists on " + cell.getHost());

		if(!c.getFile(dirPath).exists()) {
	    	ctx.logError("Directory " + dirPath + " does not exist on " + cell.getHost());
	    	validInstallation = false;
	    }
    }

	private void checkFileExistenceAndExecutability(InspectionExecutionContext ctx, OverthereConnection c, String filePath) {
		ctx.logOutput("Checking whether file " + filePath + " exists on " + cell.getHost() + " exists" + (c.getHostOperatingSystem() == UNIX ? " and is executable" : ""));
	    
		if(!c.getFile(filePath).exists()) {
	    	ctx.logError("File " + filePath + " does not exist on " + cell.getHost());
	    	validInstallation = false;
	    } else if(c.getHostOperatingSystem() == UNIX && !c.getFile(filePath).canExecute()) {
	    	ctx.logError("File " + filePath + " on " + cell.getHost() + " is not executable");
	    	validInstallation = false;
	    }
    }

	@Override
	public String getDescription() {
		return "Checking whether " + cell + " is a valid WebSphere Application Server installation";
	}


}
