#
import sys
import traceback

print "Inspecting cell %s" % (container.name)

# Inspect cell name
try:
    cell = AdminConfig.list('Cell')
    cellName = AdminConfig.showAttribute(cell, 'name');
except:
    print "Cannot get cell information. Have you entered the correct username and password to administer WebSphere Application Server?"
    traceback.print_exc()
    sys.exit(1)

if container.wasConfigIdType == 'Cell':
    if container.name != cellName:
        print "Cell name is %s instead of %s. Please set the correct ID for the was.DeploymentManager CI." % (cellName, container.name)
        sys.exit(1)
else:
    inspected('cellName', cellName)
    server = AdminConfig.list('Server')
    serverName = AdminConfig.showAttribute(server, 'name')
    if container.name != serverName:
        print "Server name is %s instead of %s. Please set the correct ID for the was.UnmanagedServer CI." % (serverName, container.name)
        sys.exit(1)

# Discover was.NodeAgent instances - skip Nodes that have no corresponding NodeAgent
nodeagents = AdminConfig.list('NodeAgent')
nodes = AdminConfig.list('Node')
if nodes != "":
    splitNodes = nodes.splitlines()
    if container.wasConfigIdType != 'Cell' and len(splitNodes) == 1:
        inspected('nodeName', AdminConfig.showAttribute(splitNodes[0], 'name'))
    for node in splitNodes:
        name = AdminConfig.showAttribute(node, 'name')
        if nodeagents.find('/nodes/%s/servers' % (name)) != -1:
            discovered('%s/%s' % (container.id, name), 'was.NodeAgent')

# Discover was.Cluster instances
clusters = AdminConfig.list('ServerCluster')
if clusters != "":
    for cluster in clusters.splitlines():
        name = AdminConfig.showAttribute(cluster, 'name')
        discovered('%s/%s' % (container.id, name), 'was.Cluster')

# Discover was.VirtualHost instances - skip VirtualHost that live on a Node 
virtualhosts = AdminConfig.list('VirtualHost')
if virtualhosts != "":
    for virtualhost in virtualhosts.splitlines():
        if virtualhost.find('/nodes/') == -1:
            name = AdminConfig.showAttribute(virtualhost, 'name')
            discovered('%s/%s' % (container.id, name), 'was.VirtualHost')
