/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.DeploymentManager;
import com.xebialabs.deployit.plugin.was.container.Node;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Metadata(description="A WebSphere node agent.")
public class NodeAgent
extends BaseContainer
implements Node {
    @Property(required=true, asContainment=true, label="Deployment manager that manages this node agent")
    private DeploymentManager cell;
    @Property(required=true, defaultValue="was/base/synchronize-node.py", hidden=true)
    private String synchronizeScript;

    @Override
    public DeploymentManager getCell() {
        return this.cell;
    }

    public void setCell(DeploymentManager cell) {
        this.cell = cell;
    }

    public PythonManagingContainer getManagingContainer() {
        return this.getCell();
    }

    @Override
    public String getCellName() {
        return this.getCell().getCellName();
    }

    public Set<Node> getNodes() {
        return Collections.singleton(this);
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    public String getSynchronizeScript() {
        return this.synchronizeScript;
    }

    public void setSynchronizeScript(String synchronizeScript) {
        this.synchronizeScript = synchronizeScript;
    }

    @Override
    public String getContainmentPath() {
        return "/Node:" + this.getName();
    }

    @Override
    public String getShortTypeDescription() {
        return "node";
    }

    @Override
    public String getWasConfigIdType() {
        return "Node";
    }

    @Override
    public String getWasTargetType() {
        return "Node";
    }

    @Inspect
    public void inspect(InspectionPlanningContext ctx) {
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, this.getManagingContainer(), "was/container/inspect-node-agent.py", (Map)pythonVars, "Inspect " + this));
    }
}

