package com.xebialabs.deployit.plugin.was.step;

import static com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler.capturingHandler;

import com.xebialabs.deployit.plugin.api.inspection.InspectionExecutionContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionStep;
import com.xebialabs.deployit.plugin.was.container.BaseCell;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.deployit.plugin.was.util.WasVersionInfoParser;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.util.CapturingOverthereProcessOutputHandler;

@SuppressWarnings("serial")
public class GetWasVersionStep implements InspectionStep {

	private Cell cell;

	public GetWasVersionStep(Cell cell) {
		this.cell = cell;
	}

	@Override
	public com.xebialabs.deployit.plugin.api.execution.Step.Result execute(InspectionExecutionContext ctx) throws Exception {
		OverthereConnection adminConnection = cell.getHost().getConnection();
		try {
			CapturingOverthereProcessOutputHandler capturedOutput = capturingHandler();
			int res = adminConnection.execute(capturedOutput, CmdLine.build(cell.getVersionInfoPath()));
			if (res != 0) {
				ctx.logError("Non-zero exitcode from " + cell.getVersionInfoPath() + ": " + res);
				return Result.Fail;
			}
			return checkWasVersion(ctx, capturedOutput);
		} finally {
			adminConnection.close();
		}
	}

	private Result checkWasVersion(InspectionExecutionContext ctx,	CapturingOverthereProcessOutputHandler capturedOutput) {
		WasVersionInfoParser wasVersionInfoParser = new WasVersionInfoParser().parse(capturedOutput.getOutputLines());

		if (wasVersionInfoParser.isSuccess()) {
			if (wasVersionInfoParser.majorVersion == 6 && wasVersionInfoParser.minorVersion == 1) {
				((BaseCell) cell).setVersion(WasVersion.WAS_61);
			} else if (wasVersionInfoParser.majorVersion == 7 && wasVersionInfoParser.minorVersion == 0) {
				((BaseCell) cell).setVersion(WasVersion.WAS_70);
			} else if (wasVersionInfoParser.majorVersion == 8 && wasVersionInfoParser.minorVersion == 0) {
				((BaseCell) cell).setVersion(WasVersion.WAS_80);
			} else {
				ctx.logError("Cannot set version on " + cell + ": version " + wasVersionInfoParser.majorVersion + "." + wasVersionInfoParser.minorVersion + " is not supported");
				return Result.Fail;
			}
			return Result.Success;
		}
		
		ctx.logError("Could not determine installed version of " + cell);
		return Result.Fail;
	}

	@Override
	public String getDescription() {
		return "Get version of " + cell;
	}

}
