/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.container;

import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.execution.Step;
import com.xebialabs.deployit.plugin.api.inspection.Inspect;
import com.xebialabs.deployit.plugin.api.inspection.InspectionPlanningContext;
import com.xebialabs.deployit.plugin.api.inspection.InspectionProperty;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseContainer;
import com.xebialabs.deployit.plugin.overthere.Host;
import com.xebialabs.deployit.plugin.python.PythonInspectionStep;
import com.xebialabs.deployit.plugin.python.PythonManagedContainer;
import com.xebialabs.deployit.plugin.python.PythonManagingContainer;
import com.xebialabs.deployit.plugin.was.container.Cell;
import com.xebialabs.deployit.plugin.was.container.WasVersion;
import com.xebialabs.deployit.plugin.was.step.CheckWasInstallationStep;
import com.xebialabs.deployit.plugin.was.step.GetWasVersionStep;
import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.OverthereFile;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

@Metadata(description="Base class for a Webshpere Cell")
public abstract class BaseCell
extends BaseContainer
implements Cell,
PythonManagedContainer,
PythonManagingContainer {
    @Property(required=true, asContainment=true, description="Host on which the unmanaged WAS server runs")
    @InspectionProperty(required=true)
    private Host host;
    @Property(required=true, label="WebSphere Installation Path", description="Root path of the WebSphere installation path. e.g. /opt/ws/6.1/appserver/profiles/AppSrv01", size=Property.Size.LARGE)
    @InspectionProperty(required=true)
    private String wasHome;
    @Property(required=false, label="Administrative port", description="TCP port which is used to login to the WebSphere Administration, default is 8880")
    @InspectionProperty
    private int port;
    @Property(required=false, label="Administrative username", description="Username which is used to login to the WebSphere Administration.")
    @InspectionProperty
    private String username;
    @Property(required=false, password=true, label="Administrative password", description="Password which is used to login to the WebSphere Administration.")
    @InspectionProperty
    private String password;
    @Property(required=true, label="WAS version", description="Version of WebSphere Application Server.")
    private WasVersion version;
    @Property(required=true, label="Run with daemon", description="Set to true to execute commands with the Python daemon", defaultValue="true", hidden=true)
    private boolean runWithDaemon;
    private static final String CONFIG_DIR_NAME = "config";
    private static final String PLUGIN_FILENAME = "plugin-cfg.xml";

    @Override
    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String wasHome) {
        this.wasHome = wasHome;
    }

    @Override
    public WasVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(WasVersion version) {
        this.version = version;
    }

    @Override
    public Cell getCell() {
        return this;
    }

    @Override
    public Host getCellHost() {
        return this.host;
    }

    public Host getHost() {
        return this.host;
    }

    public void setHost(Host host) {
        this.host = host;
    }

    @Override
    public String getConfigDirPath() {
        String fileSep = this.getCellHost().getOs().getFileSeparator();
        return this.getWasHome() + fileSep + CONFIG_DIR_NAME;
    }

    @Override
    public String getPluginFilePath() {
        String fileSep = this.getCellHost().getOs().getFileSeparator();
        return this.getConfigDirPath() + fileSep + "cells" + fileSep + PLUGIN_FILENAME;
    }

    @Override
    public String getWsadminPath() {
        return this.getCommandPath("wsadmin");
    }

    @Override
    public String getVersionInfoPath() {
        return this.getCommandPath("versionInfo");
    }

    @Override
    public String getStartServerPath() {
        return this.getCommandPath("startServer");
    }

    @Override
    public String getStopServerPath() {
        return this.getCommandPath("stopServer");
    }

    @Override
    public String getServerStatusPath() {
        return this.getCommandPath("serverStatus");
    }

    private String getCommandPath(String command) {
        String fileSep = this.getCellHost().getOs().getFileSeparator();
        String scriptExt = this.getCellHost().getOs().getScriptExtension();
        return this.getWasHome() + fileSep + "bin" + fileSep + command + scriptExt;
    }

    public boolean runWithDaemon() {
        return this.runWithDaemon;
    }

    public void setRunWithDaemon(boolean runWithDaemon) {
        this.runWithDaemon = runWithDaemon;
    }

    public PythonManagingContainer getManagingContainer() {
        return this;
    }

    public CmdLine getScriptCommandLine(OverthereFile pyFile) {
        CmdLine commandLine = new CmdLine();
        commandLine.addArgument(this.getWsadminPath());
        if (StringUtils.isNotBlank((String)this.getUsername())) {
            commandLine.addArgument("-user");
            commandLine.addArgument(this.getUsername());
            if (!StringUtils.isEmpty((String)this.getPassword())) {
                commandLine.addArgument("-password");
                commandLine.addPassword(this.getPassword());
            }
        }
        if (this.getPort() != 0) {
            commandLine.addArgument("-port");
            commandLine.addArgument(Integer.toString(this.getPort()));
        }
        commandLine.addArgument("-lang");
        commandLine.addArgument("jython");
        commandLine.addArgument("-f");
        commandLine.addArgument(pyFile.getPath());
        return commandLine;
    }

    public String getRuntimePath() {
        return "was/runtime";
    }

    @Inspect
    public void inspect(InspectionPlanningContext ctx) {
        ctx.addStep((Step)new CheckWasInstallationStep(this));
        ctx.addStep((Step)new GetWasVersionStep(this));
        HashMap pythonVars = Maps.newHashMap();
        pythonVars.put("container", this);
        ctx.addStep((Step)new PythonInspectionStep((ConfigurationItem)this, (PythonManagingContainer)this, "was/container/inspect-cell.py", (Map)pythonVars, "Inspect " + this));
    }
}

