/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.hostsession.CapturingCommandExecutionCallbackHandler;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasVersion;
import com.xebialabs.deployit.plugin.was.utils.RegexUtils;

/**
 * Retrieve the version of a cell.
 */
@SuppressWarnings("serial")
public class RetrieveWasVersionStep extends WasStepBase {

	public RetrieveWasVersionStep(WasCell cell) {
		super(cell);
		setDescription("Retrieve version of cell " + cell);
	}

	public boolean execute(StepExecutionContext ctx) {
		HostSession adminHostSession = cell.connectToAdminHost();
		try {
			CapturingCommandExecutionCallbackHandler capturedOutput = new CapturingCommandExecutionCallbackHandler();
			int res = adminHostSession.execute(capturedOutput, cell.getVersionInfoPath());
			if (res != 0) {
				ctx.logError("Non-zero exitcode from " + cell.getVersionInfoPath() + ": " + res);
				return false;
			}
			boolean seenAppServerLine = false;
			for (String eachLine : capturedOutput.getOutputLines()) {
				if (eachLine.contains("Name") && eachLine.contains("IBM WebSphere Application Server")) {
					seenAppServerLine = true;
				}
				if (seenAppServerLine && eachLine.startsWith("Version")) {
					String[] matches = RegexUtils.regexMatch(eachLine, "Version\\s+(\\d+)\\.(\\d+)\\.[\\d\\.]*");
					if (matches != null && matches.length == 2) {
						int majorVersion = Integer.parseInt(matches[0]);
						int minorVersion = Integer.parseInt(matches[1]);
						int expectedMajorVersion;
						int expectedMinorVersion;
						if (cell.getVersion() == WasVersion.WAS_61) {
							expectedMajorVersion = 6;
							expectedMinorVersion = 1;
						} else if (cell.getVersion() == WasVersion.WAS_70) {
							expectedMajorVersion = 7;
							expectedMinorVersion = 0;
						} else {
							ctx.logOutput("There is no version set on cell " + cell + " trying to set it");
							if (majorVersion == 6 && minorVersion == 1) {
								cell.setVersion(WasVersion.WAS_61);
								return true;
							} else if (majorVersion == 7 && minorVersion == 0) {
								cell.setVersion(WasVersion.WAS_70);
								return true;
							}
							ctx.logError("Could not set version on cell " + cell + " majorVersion: " + majorVersion + " minorVersion: " + minorVersion
							        + " Giving up");
							return false;
						}

						boolean correctVersion = (majorVersion == expectedMajorVersion) && (minorVersion == expectedMinorVersion);
						if (!correctVersion) {
							ctx.logError("Cell " + cell + " is an installation of WebSphere " + majorVersion + "." + minorVersion + " instead of the expected "
							        + expectedMajorVersion + "." + expectedMinorVersion);
							return false;
						} else {
							ctx.logOutput("Cell " + cell + " is an installation of WebSphere " + majorVersion + "." + minorVersion);
							return true;
						}
					}
				}
			}
			ctx.logError("Could not determine installed version of cell " + cell);
			return false;
		} finally {
			adminHostSession.close();
		}
	}

}
