/*
 * Copyright (c) 2008-2010 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.step;

import static com.google.common.collect.Lists.newArrayList;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsActivationSpec;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsQueue;
import com.xebialabs.deployit.plugin.was.ci.WasSibJmsTarget;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;

/**
 * Creates a {@link WasSibJmsActivationSpec} in a {@link WasTarget}
 */
@SuppressWarnings("serial")
public class CreateWasSibJmsActivationSpecStep extends WasStepBase implements Step {
	private static String CREATE_SIB_JMS_AS_SCRIPT_RESOURCE_PATH = STEP_RESOURCES_PATH + "create-sib-jms-activation-spec.py";

	private WasSibJmsActivationSpec as;
	private WasTarget target;

	public CreateWasSibJmsActivationSpecStep(WasTarget target, WasSibJmsActivationSpec as) {
		super(target.getCell());
		this.as = as;
		this.target = target;
		setDescription("Create WebSphere Activation Specification " + as + " in " + target.getShortTypeDescription() + " " + target 
				+ " using the Default messaging provider");
	}

	public boolean execute(StepExecutionContext ctx) {
		Map<String, Serializable> context = new HashMap<String, Serializable>();
		context.put("as", as);
		int res = executeWsadminJythonScriptResource(ctx, context, CREATE_SIB_JMS_AS_SCRIPT_RESOURCE_PATH, getArgs().toArray(new String[0]));
		return res == 0;
	}

	private List<String> getArgs() {
		WasSibJmsTarget jmsTarget = as.getDestination();
		List<String> args = newArrayList();
		String targetContainmentPath = "/" + target.getWasConfigIdType() + ":" + target.getName();
		args.add(targetContainmentPath);
		args.add(jmsTarget.getJndiName());
		args.add((jmsTarget instanceof WasSibJmsQueue) ? "Queue" : "Topic");
		args.add(jmsTarget.getBusName());
		return args;
	}
}
