/*
 * Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
 *
 * Your use of XebiaLabs Software and Documentation is subject to the Personal
 * License Agreement.
 *
 * http://www.xebialabs.com/deployit-personal-edition-license-agreement
 *
 * You are granted a personal license (i) to use the Software for your own
 * personal purposes which may be used in a production environment and/or (ii)
 * to use the Documentation to develop your own plugins to the Software.
 * "Documentation" means the how to's and instructions (instruction videos)
 * provided with the Software and/or available on the XebiaLabs website or other
 * websites as well as the provided API documentation, tutorial and access to
 * the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
 * or sublicense the Software or Documentation to any third party, or otherwise
 * use it except as permitted in this agreement; (ii) reverse engineer,
 * decompile, disassemble, or otherwise attempt to determine source code or
 * protocols from the Software, and/or to (iii) copy the Software or
 * Documentation (which includes the source code of the XebiaLabs plugins). You
 * shall not create or attempt to create any derivative works from the Software
 * except and only to the extent permitted by law. You will preserve XebiaLabs'
 * copyright and legal notices on the Software and Documentation. XebiaLabs
 * retains all rights not expressly granted to You in the Personal License
 * Agreement.
 */

package com.xebialabs.deployit.plugin.was.runbook;

import static com.xebialabs.deployit.reflect.ConfigurationItemReflectionUtils.isIdentical;

import java.util.List;

import com.xebialabs.deployit.Change;
import com.xebialabs.deployit.ChangePlan;
import com.xebialabs.deployit.Step;
import com.xebialabs.deployit.ci.Deployment;
import com.xebialabs.deployit.ci.Environment;
import com.xebialabs.deployit.plugin.was.ci.WasServer;
import com.xebialabs.deployit.util.SingleTypeHandlingRunBook;

abstract class WasServerRunBook<T extends WasServer> extends SingleTypeHandlingRunBook<T> {

	public WasServerRunBook(Class<T> serverType) {
		super(serverType);
	}

	public void resolve(Change<T> change, ChangePlan changePlan, List<Step> steps) {
		T oldServer = change.getOldRevision();
		T newServer = change.getNewRevision();
		
		if (!isIdentical(oldServer, newServer) && isEligibleChange(change, changePlan)) {
			if (change.isModification() && !serverEnvironmentBeingDeployedTo(change, changePlan)) { 
				getStepsForModifiedServer(steps, oldServer, newServer);
			}

			if (change.isDeletion()) {
				getStepsForDeletedServer(steps, oldServer);
			}

			if (change.isAddition()) {
				getStepsForAddedServer(steps, newServer);
			}
		}
	}

	protected abstract boolean isEligibleChange(Change<T> change, ChangePlan changePlan);

	protected abstract void getStepsForDeletedServer(List<Step> steps, T oldServer);
	
	protected abstract void getStepsForModifiedServer(List<Step> steps, T oldServer, T newServer);
	
	protected abstract void getStepsForAddedServer(List<Step> steps, T newServer);
	
	private boolean serverEnvironmentBeingDeployedTo(Change<T> serverChange, ChangePlan changePlan) {
		return findDeploymentToModifiedServersEnvironment(serverChange, changePlan) != null;
	}

	@SuppressWarnings("unchecked")
	private Change<Deployment> findDeploymentToModifiedServersEnvironment(Change<T> serverChange, ChangePlan changePlan) {
		for (Change<?> change : changePlan.getChanges()) {
			if (change.isModification() && Deployment.class.isAssignableFrom(change.getConfigurationItemClass())) {
				Deployment oldDeployment = (Deployment) change.getOldRevision();
				Deployment newDeployment = (Deployment) change.getNewRevision();
				if (isMember(oldDeployment.getTarget(), serverChange.getOldRevision()) 
						&& isMember(newDeployment.getTarget(), serverChange.getNewRevision())) {
					return (Change<Deployment>) change;
				}
			}
		}
		return null;
	}

	private static boolean isMember(Environment environment, WasServer server) {
		return environment.getMembersOfType(WasServer.class).contains(server);
	}
}
