#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys

appname = sys.argv.pop(0)
appfilepath = sys.argv.pop(0)
targets = sys.argv.pop(0)
virtualHostName = sys.argv.pop(0)
librarynames = sys.argv.pop(0)
contextroot = sys.argv.pop(0)
startingWeight = sys.argv.pop(0)
classloaderMode = sys.argv.pop(0)
classloaderPolicy = sys.argv.pop(0)
numberOfResourceEnvironmentMappings = sys.argv.pop(0)
numberOfResourceReferenceMappings = sys.argv.pop(0)
numberOfEjbReferenceMappings = sys.argv.pop(0)
numberOfMdbListenerPortBindings = sys.argv.pop(0)
numberOfSecurityRolesMappings = sys.argv.pop(0)
numberWarWebserverMappings = sys.argv.pop(0)
numberOfWarClassLoadingMappings = sys.argv.pop(0)

servermappings = []
servermappings.append(['.*', '.*', targets])
vhostmappings = []
if virtualHostName != "" and virtualHostName != " ":
    vhostmappings.append(['.*', '.*', virtualHostName])

if numberWarWebserverMappings != "0":
    for i in range(0, int(numberWarWebserverMappings)):
        warJarName =  sys.argv.pop(0)
        webservertarget = sys.argv.pop(0)
        vhostAlias = sys.argv.pop(0)
        if webservertarget != '' and warJarName != '':
        	servermappings.append(['.*', warJarName+',WEB-INF/web.xml', webservertarget])
        if  vhostAlias != '' and warJarName != '':	
        	vhostmappings.append(['.*', warJarName+',WEB-INF/web.xml', vhostAlias])

resourceenvironmentmappings = []
if numberOfResourceEnvironmentMappings != "0":
	for i in range(0, int(numberOfResourceEnvironmentMappings)):
		resenvreference = sys.argv.pop(0)
		resenvjndiname = sys.argv.pop(0)
		resourceenvironmentmappings.append(['.*', '', '.*', resenvreference, '.*', resenvjndiname])
	
resourcereferencemappings = []
if numberOfResourceReferenceMappings != "0":
	for i in range(0, int(numberOfResourceReferenceMappings)):
		resenvreference = sys.argv.pop(0)
		resenvjndiname = sys.argv.pop(0)
		resourcereferencemappings.append(['.*', '', '.*', resenvreference, '.*', resenvjndiname, '', ''])

ejbreferencemappings = []
if numberOfEjbReferenceMappings != "0":
	for i in range(0, int(numberOfEjbReferenceMappings)):
		ejbreference = sys.argv.pop(0)
		local = sys.argv.pop(0)
		beanjndiname = sys.argv.pop(0)
		ejbreferencemappings.append(['.*', '', '.*', ejbreference, local, beanjndiname])
		
mdblistenerportbindings = []
if numberOfMdbListenerPortBindings != "0":
	for i in range(0, int(numberOfMdbListenerPortBindings)):
		modulename = sys.argv.pop(0)
		mdbname = sys.argv.pop(0)
		listenerport = sys.argv.pop(0)
		mdblistenerportbindings.append([modulename, mdbname, '.*', listenerport, '', '', ''])

rolesTousersGroupsMapping = []
if numberOfSecurityRolesMappings != "0":
	for i in range(0, int(numberOfSecurityRolesMappings)):
		roleName = sys.argv.pop(0)
		userName = sys.argv.pop(0)
		groups = sys.argv.pop(0)
		if userName != '' or groups != '' :
			rolesTousersGroupsMapping.append([roleName,'No','No',userName,groups])
		
libraries = librarynames.replace(",", "+")
sharedlibmappings = []
if(libraries != ''):
	sharedlibmappings.append(['.*', '.*', libraries])
    
if (numberOfResourceEnvironmentMappings != "0") or (numberOfResourceReferenceMappings != "0") or (numberOfEjbReferenceMappings != "0") :
	args = ['-appname', appname, '-MapModulesToServers', servermappings, '-MapWebModToVH', vhostmappings, '-MapResEnvRefToRes', resourceenvironmentmappings, '-MapResRefToEJB', resourcereferencemappings, '-MapEJBRefToEJB', ejbreferencemappings]
else:
	args = ['-appname', appname, '-MapModulesToServers', servermappings, '-MapWebModToVH', vhostmappings, '-usedefaultbindings']

if len(mdblistenerportbindings) != 0:
    args.extend(['-BindJndiForEJBMessageBinding', mdblistenerportbindings])
	
if len(sharedlibmappings) != 0:
	args.extend(['-MapSharedLibForMod', sharedlibmappings])

if contextroot != '' and contextroot != ' ':
    args.extend(['-contextroot', contextroot])


if len(rolesTousersGroupsMapping) != 0:
	args.extend(['-MapRolesToUsers',rolesTousersGroupsMapping])

print "Installing", appname, "from", appfilepath, "to targets", targets, "and virtual host", virtualHostName, "with args", args
AdminApp.install(appfilepath, args)

print "Setting starting weight for application to " + startingWeight
deployment = AdminConfig.getid('/Deployment:' + appname + '/')
deploymentObject = AdminConfig.showAttribute(deployment, 'deployedObject')
AdminConfig.modify(deploymentObject, [['startingWeight', startingWeight]])
if classloaderPolicy != '':
	AdminConfig.modify(deploymentObject, [['warClassLoaderPolicy', classloaderPolicy]])
if classloaderMode != '':	
	classLoaderAttr = AdminConfig.showAttribute(deploymentObject, 'classloader')
	AdminConfig.modify(classLoaderAttr, [['mode', classloaderMode]])

warClassLoadingMappings = []
if numberOfWarClassLoadingMappings != "0":
	myModules = AdminConfig.showAttribute(deploymentObject, 'modules')
	myModules = myModules[1:len(myModules)-1].split(" ")
	for i in range(0, int(numberOfWarClassLoadingMappings)):
		webmodule   = sys.argv.pop(0)
		warclassmode = sys.argv.pop(0)
		if warclassmode != '':
			for module in myModules:
				uri = AdminConfig.showAttribute(module, 'uri')
				if uri == webmodule :
					AdminConfig.modify(module, [['classloaderMode', warclassmode]])
					break

print "Saving configuration"
AdminConfig.save()
