#
# Copyright (c) 2008-2011 XebiaLabs B.V. All rights reserved.
#
# Your use of XebiaLabs Software and Documentation is subject to the Personal
# License Agreement.
#
# http://www.xebialabs.com/deployit-personal-edition-license-agreement
#
# You are granted a personal license (i) to use the Software for your own
# personal purposes which may be used in a production environment and/or (ii)
# to use the Documentation to develop your own plugins to the Software.
# "Documentation" means the how to's and instructions (instruction videos)
# provided with the Software and/or available on the XebiaLabs website or other
# websites as well as the provided API documentation, tutorial and access to
# the source code of the XebiaLabs plugins. You agree not to (i) lease, rent
# or sublicense the Software or Documentation to any third party, or otherwise
# use it except as permitted in this agreement; (ii) reverse engineer,
# decompile, disassemble, or otherwise attempt to determine source code or
# protocols from the Software, and/or to (iii) copy the Software or
# Documentation (which includes the source code of the XebiaLabs plugins). You
# shall not create or attempt to create any derivative works from the Software
# except and only to the extent permitted by law. You will preserve XebiaLabs'
# copyright and legal notices on the Software and Documentation. XebiaLabs
# retains all rights not expressly granted to You in the Personal License
# Agreement.
#

import sys
	
sys.argv.reverse();
nodename = sys.argv.pop();
clustername = sys.argv.pop();
membernameprefix = sys.argv.pop();
numberOfMembers = sys.argv.pop();

if len(sys.argv) >= 1 :
	endpointport = int(sys.argv.pop());
	endpointname = sys.argv.pop();
else :
	endpointport = -1;
	
if len(sys.argv) >= 1 :
	secondendpointport = int(sys.argv.pop());
	secondendpointname = sys.argv.pop();
else :
	secondendpointport = -1;
	
num = 1;
startnum = 1;
clusterId = AdminConfig.getid('/ServerCluster:'+clustername+'/')

if clusterId == "" :
	print "Cluster " + clustername + " does not exist."
	sys.exit(1)
        
firstmemberlist = AdminConfig.list('ClusterMember', clusterId)
if firstmemberlist == "" :
	print "Creating first cluster member " + membernameprefix + str(num)
	AdminTask.createClusterMember('[-clusterName '+ clustername + ' -memberConfig [-memberNode '+nodename+ ' -memberName '+ membernameprefix + str(num) + ' -memberWeight 2] -firstMember [-templateName default -nodeGroup DefaultNodeGroup -coreGroup DefaultCoreGroup]]')
	startnum=2
	if endpointport >= 1 :
		server = AdminConfig.getid('/Server:' + membernameprefix + str(num) +'/');
		nameServer = AdminConfig.list('NameServer', server);
		currentDefinition = AdminConfig.showAttribute(nameServer, endpointname);
		endpointhost = AdminConfig.showAttribute(currentDefinition, 'host');
		print "Modifying port " + endpointname + " to " + endpointhost + ":" + str(endpointport) + " on cluster " + clustername + " on node " + nodename + " for member " + membernameprefix + str(num)
		AdminConfig.modify(nameServer, [[endpointname, [['port', endpointport], ['host', endpointhost]]]]);
		endpointport = endpointport + 1;
 	if secondendpointport >= 1 :
 		server = AdminConfig.getid('/Server:' + membernameprefix + str(num) +'/');
 		soap = AdminConfig.list('SOAPConnector', server);
 		currentDefinition = AdminConfig.showAttribute(soap, secondendpointname);
 		endpointhost = AdminConfig.showAttribute(currentDefinition, 'host');
 		print "Modifying port " + secondendpointname + " to " + endpointhost + ":" + str(secondendpointport) + " on cluster " + clustername + " on node " + nodename + " for member " + membernameprefix + str(num)
 		AdminConfig.modify(soap, [[secondendpointname, [['port', secondendpointport], ['host', endpointhost]]]]);
 		secondendpointport = secondendpointport + 1;
                
for i in range(startnum,int(numberOfMembers)+1):
	print "Creating cluster member " + membernameprefix + str(i)
	AdminTask.createClusterMember('[-clusterName '+ clustername + ' -memberConfig [-memberNode '+nodename+ ' -memberName '+ membernameprefix +str(i)+' -memberWeight 2]]')
	if endpointport >= 1 :
		server = AdminConfig.getid('/Server:' + membernameprefix + str(i) +'/');
		nameServer = AdminConfig.list('NameServer', server);
		currentDefinition = AdminConfig.showAttribute(nameServer, endpointname);
		endpointhost = AdminConfig.showAttribute(currentDefinition, 'host');
		print "Modifying port " + endpointname + " to " + endpointhost + ":" + str(endpointport) + " on cluster " + clustername + " on node " + nodename + " for member " + membernameprefix + str(i)
		AdminConfig.modify(nameServer, [[endpointname, [['port', endpointport], ['host', endpointhost]]]]);
		endpointport = endpointport + 1;
	if secondendpointport >= 1 :
		server = AdminConfig.getid('/Server:' + membernameprefix + str(i) +'/');
		soap = AdminConfig.list('SOAPConnector', server);
		currentDefinition = AdminConfig.showAttribute(soap, secondendpointname);
		endpointhost = AdminConfig.showAttribute(currentDefinition, 'host');
		print "Modifying port " + secondendpointname + " to " + endpointhost + ":" + str(secondendpointport) + " on cluster " + clustername + " on node " + nodename + " for member " + membernameprefix + str(i)
		AdminConfig.modify(soap, [[secondendpointname, [['port', secondendpointport], ['host', endpointhost]]]]);
		secondendpointport = secondendpointport + 1;
      
print "Saving configuration"               
AdminConfig.save()
