/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.was.step;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.ResolutionException;
import com.xebialabs.deployit.StepExecutionContext;
import com.xebialabs.deployit.ci.Host;
import com.xebialabs.deployit.ci.artifact.Ear;
import com.xebialabs.deployit.ci.artifact.EjbJar;
import com.xebialabs.deployit.ci.artifact.NamedDeployableArtifact;
import com.xebialabs.deployit.ci.artifact.War;
import com.xebialabs.deployit.ci.mapping.EjbReference;
import com.xebialabs.deployit.ci.mapping.MdbListenerPortBinding;
import com.xebialabs.deployit.ci.mapping.ResourceReference;
import com.xebialabs.deployit.hostsession.HostFile;
import com.xebialabs.deployit.hostsession.HostFileUtils;
import com.xebialabs.deployit.hostsession.HostSession;
import com.xebialabs.deployit.plugin.was.ci.SecurityRoleUserGroupMappings;
import com.xebialabs.deployit.plugin.was.ci.WarsWebserversVirtualHostMapping;
import com.xebialabs.deployit.plugin.was.ci.WasCell;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderMode;
import com.xebialabs.deployit.plugin.was.ci.WasClassLoaderPolicy;
import com.xebialabs.deployit.plugin.was.ci.WasManagedApacheHttpdServer;
import com.xebialabs.deployit.plugin.was.ci.WasSharedLibrary;
import com.xebialabs.deployit.plugin.was.ci.WasTarget;
import com.xebialabs.deployit.plugin.was.ci.WasWarClassLoaderMapping;
import com.xebialabs.deployit.plugin.was.step.WasStepBase;
import com.xebialabs.deployit.util.ExtendedStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;

public class WasDeployApplicationStep
extends WasStepBase {
    protected static final String DEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH = "com/xebialabs/deployit/plugin/was/step/deploy-application.py";
    protected NamedDeployableArtifact application;
    protected String extension;
    protected Collection<? extends WasTarget> targets;
    protected Collection<WasManagedApacheHttpdServer> webservers;
    protected String virtualHostName;
    private String libraries;
    protected String contextRoot;
    protected int startingWeight = 1;
    protected List<ResourceReference> resourceEnvironmentEntryReferences;
    protected List<ResourceReference> resourceReferences;
    protected List<EjbReference> ejbReferences;
    protected List<MdbListenerPortBinding> mdbListenerPortBindings = Lists.newArrayList();
    protected List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings = Lists.newArrayList();
    protected List<WarsWebserversVirtualHostMapping> warsWebserversVirtualHostMapping = Lists.newArrayList();
    protected String earClassLoaderPolicy = "";
    protected String classLoaderMode = "";
    protected List<WasWarClassLoaderMapping> warClassLoaderMappings = Lists.newArrayList();

    public WasDeployApplicationStep(WasCell cell, Ear ear, Collection<? extends WasTarget> targets, Collection<WasManagedApacheHttpdServer> webservers, String virtualHostName, Set<WasSharedLibrary> libraries, int startingWeight, WasClassLoaderMode classLoaderMode, WasClassLoaderPolicy earClassLoaderPolicy, List<WasWarClassLoaderMapping> warClassLoaderMappings, List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings, List<WarsWebserversVirtualHostMapping> warsWebserversVirtualHostMapping) {
        this(cell, targets, webservers, virtualHostName, libraries);
        this.application = (NamedDeployableArtifact)Preconditions.checkNotNull((Object)ear);
        this.extension = ".ear";
        this.contextRoot = "";
        this.startingWeight = startingWeight;
        this.resourceEnvironmentEntryReferences = Collections.emptyList();
        this.resourceReferences = Collections.emptyList();
        this.ejbReferences = Collections.emptyList();
        if (securityRoleUserGroupMappings != null) {
            this.securityRoleUserGroupMappings = securityRoleUserGroupMappings;
        }
        if (warsWebserversVirtualHostMapping != null) {
            this.warsWebserversVirtualHostMapping = warsWebserversVirtualHostMapping;
        }
        if (earClassLoaderPolicy != null) {
            this.earClassLoaderPolicy = earClassLoaderPolicy.toString();
        }
        if (classLoaderMode != null) {
            this.classLoaderMode = classLoaderMode.toString();
        }
        if (warClassLoaderMappings != null) {
            this.warClassLoaderMappings = warClassLoaderMappings;
        }
        this.validate();
        this.initDescription();
    }

    public WasDeployApplicationStep(WasCell cell, War war, Collection<? extends WasTarget> targets, Collection<WasManagedApacheHttpdServer> webservers, String virtualHostName, Set<WasSharedLibrary> libraries, String contextRoot, int startingWeight, WasClassLoaderMode warclassLoaderMode, List<ResourceReference> resourceEnvironmentJndiNameMappings, List<ResourceReference> resourceReferenceJndiNameMappings, List<EjbReference> ejbReferenceJndiNameMappings, List<SecurityRoleUserGroupMappings> securityRoleUserGroupMappings) {
        this(cell, targets, webservers, virtualHostName, libraries);
        this.application = (NamedDeployableArtifact)Preconditions.checkNotNull((Object)war);
        this.startingWeight = startingWeight;
        this.extension = ".war";
        this.resourceEnvironmentEntryReferences = resourceEnvironmentJndiNameMappings;
        this.resourceReferences = resourceReferenceJndiNameMappings;
        this.ejbReferences = ejbReferenceJndiNameMappings;
        if (securityRoleUserGroupMappings != null) {
            this.securityRoleUserGroupMappings = securityRoleUserGroupMappings;
        }
        if (warclassLoaderMode != null) {
            this.classLoaderMode = warclassLoaderMode.toString();
        }
        if (contextRoot == null) {
            throw new ResolutionException("Context root definition \"" + contextRoot + "\" is not valid. It is required for a war deployment.");
        }
        this.contextRoot = contextRoot;
        this.validate();
        this.initDescription();
    }

    public WasDeployApplicationStep(WasCell cell, EjbJar ejbJar, Collection<? extends WasTarget> targets, Set<WasSharedLibrary> libraries, int startingWeight, List<MdbListenerPortBinding> mdbListenerPortBindings) {
        this(cell, targets, null, null, libraries);
        this.application = (NamedDeployableArtifact)Preconditions.checkNotNull((Object)ejbJar);
        this.extension = ".jar";
        this.contextRoot = "";
        this.startingWeight = startingWeight;
        this.resourceEnvironmentEntryReferences = Collections.emptyList();
        this.resourceReferences = Collections.emptyList();
        this.ejbReferences = Collections.emptyList();
        this.mdbListenerPortBindings = mdbListenerPortBindings;
        this.validate();
        this.initDescription();
    }

    private WasDeployApplicationStep(WasCell cell, Collection<? extends WasTarget> targets, Collection<WasManagedApacheHttpdServer> webservers, String virtualHostName, Set<WasSharedLibrary> libraries) {
        super(cell);
        this.targets = (Collection)Preconditions.checkNotNull(targets);
        this.webservers = webservers == null ? new HashSet<WasManagedApacheHttpdServer>() : new HashSet<WasManagedApacheHttpdServer>(webservers);
        this.virtualHostName = StringUtils.defaultString((String)virtualHostName, (String)"default_host");
        this.libraries = this.convertLibrariesToString(libraries);
    }

    private void validate() {
        if (this.targets.isEmpty()) {
            throw new IllegalArgumentException("Collection of targets is empty");
        }
        for (WasTarget wasTarget : this.targets) {
            if (wasTarget.getCell().equals(this.cell)) continue;
            throw new IllegalArgumentException(StringUtils.capitalize((String)wasTarget.getShortTypeDescription()) + " " + wasTarget + " is part of cell " + wasTarget.getCell() + " so it cannot be targeted when deploying to cell " + this.cell);
        }
        for (WasManagedApacheHttpdServer wasManagedApacheHttpdServer : this.webservers) {
            if (wasManagedApacheHttpdServer.getNode().getCell().equals(this.cell)) continue;
            throw new IllegalArgumentException("WebServer " + (Object)((Object)wasManagedApacheHttpdServer) + " is part of cell " + wasManagedApacheHttpdServer.getNode().getCell() + " so it cannot be targeted when deploying to cell " + this.cell);
        }
        for (WarsWebserversVirtualHostMapping warsWebserversVirtualHostMapping : this.warsWebserversVirtualHostMapping) {
            Set<WasManagedApacheHttpdServer> mappedWebservers = warsWebserversVirtualHostMapping.getWebservers();
            if (mappedWebservers == null) continue;
            for (WasManagedApacheHttpdServer eachWebServer : mappedWebservers) {
                if (eachWebServer.getNode().getCell().equals(this.cell)) continue;
                throw new IllegalArgumentException("WebServer " + (Object)((Object)eachWebServer) + " is part of cell " + eachWebServer.getNode().getCell() + " so it cannot be targeted when deploying to cell " + this.cell);
            }
        }
        this.checkResourceReferences(this.resourceEnvironmentEntryReferences);
        this.checkResourceReferences(this.resourceReferences);
        this.checkEjbReferences(this.ejbReferences);
        for (MdbListenerPortBinding mdbListenerPortBinding : this.mdbListenerPortBindings) {
            if (!StringUtils.isBlank((String)mdbListenerPortBinding.getEjbModuleName()) && !StringUtils.isBlank((String)mdbListenerPortBinding.getMdbName()) && !StringUtils.isBlank((String)mdbListenerPortBinding.getListenerPort())) continue;
            throw new IllegalArgumentException("MDB listener port binding can't contain empty value for module name, mdb name or listener port name");
        }
    }

    private void checkResourceReferences(List<ResourceReference> mappings) {
        for (ResourceReference mapping : mappings) {
            String sourceJndiName = mapping.getResourceReference();
            String targetJndiName = mapping.getTargetResourceJndiName();
            if (!StringUtils.isNotBlank((String)sourceJndiName) || !StringUtils.isBlank((String)targetJndiName)) continue;
            throw new IllegalArgumentException("Reference with jndi name: " + sourceJndiName + " for artifact " + this.application.getName() + " must be mapped to a jndi name in the target");
        }
    }

    private void checkEjbReferences(List<EjbReference> mappings) {
        for (EjbReference mapping : mappings) {
            String sourceJndiName = mapping.getResourceReference();
            String classNameString = mapping.getClassName();
            String targetJndiName = mapping.getTargetResourceJndiName();
            if (!StringUtils.isNotBlank((String)sourceJndiName) || !StringUtils.isBlank((String)classNameString) && !StringUtils.isBlank((String)targetJndiName)) continue;
            throw new IllegalArgumentException("class value and targetJndiName must be provided for ejb reference: " + sourceJndiName);
        }
    }

    private void initDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("Deploy application ");
        desc.append(this.application);
        desc.append(" on ");
        boolean isFirstTarget = true;
        for (WasTarget wasTarget : this.targets) {
            if (!isFirstTarget) {
                desc.append(" and ");
            } else {
                isFirstTarget = false;
            }
            desc.append(wasTarget.getShortTypeDescription() + " " + wasTarget);
        }
        if (this.webservers.size() == 1) {
            desc.append(" and webserver " + (Object)((Object)this.webservers.iterator().next()));
        } else if (this.webservers.size() > 1) {
            desc.append(" and multiple webservers ");
        }
        desc.append(" in cell ");
        desc.append(this.cell);
        desc.append(" with virtual host ");
        desc.append(this.virtualHostName);
        this.setDescription(desc.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(StepExecutionContext ctx) {
        HostSession rhs = this.cell.connectToAdminHost();
        try {
            HostFile uploadedApplicationFile = this.uploadApplication(rhs);
            String earFilePath = uploadedApplicationFile.getPath().replace('\\', '/');
            StringBuilder targetsString = new StringBuilder();
            for (WasTarget wasTarget : this.targets) {
                if (targetsString.length() > 0) {
                    targetsString.append("+");
                }
                targetsString.append("WebSphere:cell=");
                targetsString.append(this.cell.getCellName());
                targetsString.append("," + wasTarget.getWasTargetType() + "=");
                targetsString.append(wasTarget.getName());
            }
            for (WasManagedApacheHttpdServer wasManagedApacheHttpdServer : this.webservers) {
                targetsString.append("+WebSphere:cell=");
                targetsString.append(this.cell.getCellName());
                targetsString.append(",node=");
                targetsString.append(wasManagedApacheHttpdServer.getNode().getNodeName());
                targetsString.append(",server=");
                targetsString.append(wasManagedApacheHttpdServer.getName());
            }
            int numberOfResourceEnvironmentJndiMappings = this.resourceEnvironmentEntryReferences.size();
            String[] stringArray = new String[numberOfResourceEnvironmentJndiMappings * 2];
            int resourceEnvironmentInfoIndex = 0;
            for (ResourceReference resourceEnvironmentJndiNameMapping : this.resourceEnvironmentEntryReferences) {
                stringArray[resourceEnvironmentInfoIndex++] = resourceEnvironmentJndiNameMapping.getResourceReference();
                stringArray[resourceEnvironmentInfoIndex++] = resourceEnvironmentJndiNameMapping.getTargetResourceJndiName();
            }
            int numberOfResourceReferenceMappings = this.resourceReferences.size();
            String[] resourceReferenceInfo = new String[numberOfResourceReferenceMappings * 2];
            int resourceReferenceInfoIndex = 0;
            for (ResourceReference resourceReferenceJndiNameMapping : this.resourceReferences) {
                resourceReferenceInfo[resourceReferenceInfoIndex++] = resourceReferenceJndiNameMapping.getResourceReference();
                resourceReferenceInfo[resourceReferenceInfoIndex++] = resourceReferenceJndiNameMapping.getTargetResourceJndiName();
            }
            int numberOfEjbJndiMappings = this.ejbReferences.size();
            String[] ejbReferenceInfo = new String[numberOfEjbJndiMappings * 3];
            int ejbReferenceInfoIndex = 0;
            for (EjbReference ejbReferenceJndiNameMapping : this.ejbReferences) {
                ejbReferenceInfo[ejbReferenceInfoIndex++] = ejbReferenceJndiNameMapping.getResourceReference();
                ejbReferenceInfo[ejbReferenceInfoIndex++] = ejbReferenceJndiNameMapping.getClassName();
                ejbReferenceInfo[ejbReferenceInfoIndex++] = ejbReferenceJndiNameMapping.getTargetResourceJndiName();
            }
            int numberOfMdbPortBindings = this.mdbListenerPortBindings.size();
            String[] mdbPortBindingsInfo = new String[numberOfMdbPortBindings * 3];
            int portBindingIndex = 0;
            for (MdbListenerPortBinding eachBinding : this.mdbListenerPortBindings) {
                mdbPortBindingsInfo[portBindingIndex++] = eachBinding.getEjbModuleName();
                mdbPortBindingsInfo[portBindingIndex++] = eachBinding.getMdbName();
                mdbPortBindingsInfo[portBindingIndex++] = eachBinding.getListenerPort();
            }
            int numberOfWarClassLoaderMappings = this.warClassLoaderMappings.size();
            String[] warClassLoaderMappingsInfo = new String[numberOfWarClassLoaderMappings * 2];
            int WarclassLoaderBindingIndex = 0;
            for (WasWarClassLoaderMapping eachBinding : this.warClassLoaderMappings) {
                warClassLoaderMappingsInfo[WarclassLoaderBindingIndex++] = eachBinding.getWarName();
                if (eachBinding.getClassLoaderMode() != null) {
                    warClassLoaderMappingsInfo[WarclassLoaderBindingIndex++] = eachBinding.getClassLoaderMode().toString();
                    continue;
                }
                warClassLoaderMappingsInfo[WarclassLoaderBindingIndex++] = "";
            }
            int numberOfSecurityRolesMappings = this.securityRoleUserGroupMappings.size();
            String[] securityRolesInfo = new String[numberOfSecurityRolesMappings * 3];
            int securityRoleIndex = 0;
            for (SecurityRoleUserGroupMappings eachBinding : this.securityRoleUserGroupMappings) {
                securityRolesInfo[securityRoleIndex++] = eachBinding.getSecurityRole();
                securityRolesInfo[securityRoleIndex++] = eachBinding.getUsers();
                securityRolesInfo[securityRoleIndex++] = eachBinding.getGroups();
            }
            int numberWarWebserverMappings = this.warsWebserversVirtualHostMapping.size();
            String[] webServerVHInfo = new String[numberWarWebserverMappings * 3];
            int webserverMappingIndex = 0;
            for (WarsWebserversVirtualHostMapping eachBinding : this.warsWebserversVirtualHostMapping) {
                webServerVHInfo[webserverMappingIndex++] = eachBinding.getWarName();
                webServerVHInfo[webserverMappingIndex++] = this.getWebserverTarget(eachBinding);
                webServerVHInfo[webserverMappingIndex++] = eachBinding.getVirtualHost();
            }
            String[] args = new String[]{this.application.getName(), earFilePath, targetsString.toString(), this.virtualHostName, this.libraries, this.contextRoot, Integer.toString(this.startingWeight), this.classLoaderMode, this.earClassLoaderPolicy, Integer.toString(numberOfResourceEnvironmentJndiMappings), Integer.toString(numberOfResourceReferenceMappings), Integer.toString(numberOfEjbJndiMappings), Integer.toString(numberOfMdbPortBindings), Integer.toString(numberOfSecurityRolesMappings), Integer.toString(numberWarWebserverMappings), Integer.toString(numberOfWarClassLoaderMappings)};
            String[] allArgs = new String[args.length + stringArray.length + resourceReferenceInfo.length + ejbReferenceInfo.length + mdbPortBindingsInfo.length + securityRolesInfo.length + webServerVHInfo.length + warClassLoaderMappingsInfo.length];
            ArrayList allArgsList = Lists.newArrayList();
            allArgsList.addAll(Arrays.asList(args));
            allArgsList.addAll(Arrays.asList(webServerVHInfo));
            allArgsList.addAll(Arrays.asList(stringArray));
            allArgsList.addAll(Arrays.asList(resourceReferenceInfo));
            allArgsList.addAll(Arrays.asList(ejbReferenceInfo));
            allArgsList.addAll(Arrays.asList(mdbPortBindingsInfo));
            allArgsList.addAll(Arrays.asList(securityRolesInfo));
            allArgsList.addAll(Arrays.asList(warClassLoaderMappingsInfo));
            allArgs = allArgsList.toArray(allArgs);
            int res = this.executeWsadminJythonScriptResource(ctx, rhs, DEPLOY_APPLICATION_SCRIPT_RESOURCE_PATH, allArgs);
            boolean bl = res == 0;
            return bl;
        }
        finally {
            rhs.close();
        }
    }

    private String getWebserverTarget(WarsWebserversVirtualHostMapping eachBinding) {
        StringBuilder targetsString = new StringBuilder();
        Set<WasManagedApacheHttpdServer> webservers = eachBinding.getWebservers();
        for (WasTarget wasTarget : this.targets) {
            if (targetsString.length() > 0) {
                targetsString.append("+");
            }
            targetsString.append("WebSphere:cell=");
            targetsString.append(this.cell.getCellName());
            targetsString.append("," + wasTarget.getWasTargetType() + "=");
            targetsString.append(wasTarget.getName());
        }
        for (WasManagedApacheHttpdServer wasManagedApacheHttpdServer : webservers) {
            targetsString.append("+WebSphere:cell=");
            targetsString.append(this.cell.getCellName());
            targetsString.append(",node=");
            targetsString.append(wasManagedApacheHttpdServer.getNode().getNodeName());
            targetsString.append(",server=");
            targetsString.append(wasManagedApacheHttpdServer.getName());
        }
        return targetsString.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HostFile uploadApplication(HostSession rhs) {
        HostSession lhs = Host.getLocalHost().getHostSession();
        try {
            HostFile applicationFileToUpload = lhs.getFile(this.application.getLocation());
            HostFile uploadedApplicationFile = rhs.getTempFile(this.application.getName(), this.extension);
            HostFileUtils.copy((HostFile)applicationFileToUpload, (HostFile)uploadedApplicationFile);
            HostFile hostFile = uploadedApplicationFile;
            return hostFile;
        }
        finally {
            lhs.close();
        }
    }

    private String convertLibrariesToString(Set<WasSharedLibrary> libraries) {
        if (CollectionUtils.isNotEmpty(libraries)) {
            return ExtendedStringUtils.join(libraries, (Transformer)new Transformer(){

                public String transform(Object obj) {
                    return ((WasSharedLibrary)obj).getName();
                }
            });
        }
        return "";
    }

    public NamedDeployableArtifact getApplication() {
        return this.application;
    }

    public String getExtension() {
        return this.extension;
    }

    public WasCell getCell() {
        return this.cell;
    }

    public Collection<? extends WasTarget> getTargets() {
        return this.targets;
    }

    public Collection<WasManagedApacheHttpdServer> getWebservers() {
        return this.webservers;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public String getContextRoot() {
        return this.contextRoot;
    }
}

